/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.ruler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.SnapToGeometryEx;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractBorderedDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SnapChangeBoundsRequest;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SnapBendpointRequest;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SiriusSnapToGeometry
extends SnapToGeometryEx {
    boolean snapToAll;

    public SiriusSnapToGeometry(GraphicalEditPart container) {
        super(container);
    }

    public int snapRectangle(Request request, int snapOrientation, PrecisionRectangle baseRect, PrecisionRectangle result) {
        Object snapToAllExtendedData = request.getExtendedData().get("snapToAllShape");
        boolean oldSnapToAll = this.snapToAll;
        boolean bl = this.snapToAll = snapToAllExtendedData != null && (Boolean)snapToAllExtendedData != false;
        if (!this.snapToAll) {
            if (request instanceof SnapChangeBoundsRequest) {
                this.snapToAll = ((SnapChangeBoundsRequest)request).isSnapToAllShape();
            } else if (request instanceof SnapBendpointRequest) {
                this.snapToAll = ((SnapBendpointRequest)request).isSnapToAllShape();
            }
        }
        if (oldSnapToAll != this.snapToAll) {
            this.rows = null;
            this.cols = null;
        }
        return super.snapRectangle(request, snapOrientation, baseRect, result);
    }

    protected List generateSnapPartsList(List exclusions) {
        if (!this.snapToAll) {
            return super.generateSnapPartsList(exclusions);
        }
        ArrayList expectedClasses = Lists.newArrayList();
        expectedClasses.add(AbstractBorderedDiagramElementEditPart.class);
        expectedClasses.add(AbstractDiagramBorderNodeEditPart.class);
        ArrayList snapPartsList = new ArrayList(new org.eclipse.sirius.ext.gef.query.EditPartQuery((EditPart)this.container.getRoot()).getAllChildren(false, (List)expectedClasses));
        ArrayList<EditPart> exclusionsWithChildren = new ArrayList<EditPart>();
        for (Object editPart : exclusions) {
            if (!(editPart instanceof EditPart)) continue;
            exclusionsWithChildren.add((EditPart)editPart);
            exclusionsWithChildren.addAll(new org.eclipse.sirius.ext.gef.query.EditPartQuery((EditPart)editPart).getAllChildren(false, (List)expectedClasses));
        }
        snapPartsList.removeAll(exclusionsWithChildren);
        Iterator iter = snapPartsList.iterator();
        while (iter.hasNext()) {
            EditPart snapPart = (EditPart)iter.next();
            if (!(snapPart instanceof IGraphicalEditPart) || new EditPartQuery((IGraphicalEditPart)snapPart).isVisibleOnViewport()) continue;
            iter.remove();
        }
        return snapPartsList;
    }

    protected void populateRowsAndCols(List parts) {
        if (!this.snapToAll) {
            super.populateRowsAndCols(parts);
        } else {
            this.rows = new SnapToGeometry.Entry[parts.size() * 3];
            this.cols = new SnapToGeometry.Entry[parts.size() * 3];
            int i = 0;
            while (i < parts.size()) {
                IGraphicalEditPart child = (IGraphicalEditPart)parts.get(i);
                Rectangle bounds = GraphicalHelper.getAbsoluteBounds((IGraphicalEditPart)child);
                this.makeRelative(this.container.getContentPane(), (Translatable)bounds);
                this.cols[i * 3] = new SiriusEntry(-1, bounds.x);
                this.rows[i * 3] = new SiriusEntry(-1, bounds.y);
                this.cols[i * 3 + 1] = new SiriusEntry(0, bounds.x + (bounds.width - 1) / 2);
                this.rows[i * 3 + 1] = new SiriusEntry(0, bounds.y + (bounds.height - 1) / 2);
                this.cols[i * 3 + 2] = new SiriusEntry(1, bounds.right() - 1);
                this.rows[i * 3 + 2] = new SiriusEntry(1, bounds.bottom() - 1);
                ++i;
            }
        }
    }

    class SiriusEntry
    extends SnapToGeometry.Entry {
        protected SiriusEntry(int type, int location) {
            super(type, location);
        }
    }
}

