/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.ui;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gmf.runtime.gef.ui.internal.tools.SelectConnectionEditPartTracker;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public class SiriusSelectConnectionEditPartTracker
extends SelectConnectionEditPartTracker {
    private boolean moveGroupActivated;
    private BendpointRequest bendpointRequest;

    public SiriusSelectConnectionEditPartTracker(ConnectionEditPart owner) {
        super(owner);
        this.setDisabledCursor(SharedCursors.NO);
    }

    protected Request createSourceRequest() {
        Request rq = super.createSourceRequest();
        if (rq instanceof BendpointRequest) {
            this.bendpointRequest = (BendpointRequest)rq;
        }
        return rq;
    }

    protected void updateSourceRequest() {
        super.updateSourceRequest();
        if (this.bendpointRequest != null) {
            if (this.moveGroupActivated) {
                this.bendpointRequest.getExtendedData().put("EDGE_MOVE_DELTA", this.computeDelta());
                this.bendpointRequest.getExtendedData().put("EDGE_GROUP_MOVE", Boolean.TRUE);
                this.bendpointRequest.getExtendedData().put("EDGE_GROUP_MOVE_HAS_BEEN_ACTIVATED_KEY", Boolean.TRUE);
            } else {
                this.bendpointRequest.getExtendedData().remove("EDGE_MOVE_DELTA");
                this.bendpointRequest.getExtendedData().put("EDGE_GROUP_MOVE", Boolean.FALSE);
            }
        }
    }

    public void deactivate() {
        super.deactivate();
        this.bendpointRequest = null;
    }

    private Dimension computeDelta() {
        Point newLocation = this.bendpointRequest.getLocation();
        Dimension diff = newLocation != null ? newLocation.getDifference(this.getStartLocation()) : this.getDragMoveDelta();
        return diff;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (0x100000C == e.keyCode) {
            this.moveGroupActivated = true;
            return true;
        }
        return super.handleKeyDown(e);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (0x100000C == e.keyCode) {
            this.moveGroupActivated = false;
            return true;
        }
        return super.handleKeyUp(e);
    }

    protected Cursor calculateCursor() {
        Command command;
        Cursor cursorToReturn = this.moveGroupActivated ? ((command = this.getCurrentCommand()) == null || !command.canExecute() ? this.getDisabledCursor() : SharedCursors.ARROW) : super.calculateCursor();
        return cursorToReturn;
    }
}

