/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ecore.diagram.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.polarsys.kitalpha.ecore.diagram.internal.ShowNeighborCommandHandler;

public class ShowService {
    public Collection<EObject> showReferences(EObject eObject, Collection<EObject> displayedNodes) {
        if (eObject instanceof EClass) {
            EClass root = (EClass)eObject;
            UniqueEList result = new UniqueEList();
            for (EObject o : root.eCrossReferences()) {
                EClassifier owner;
                if (!(o instanceof EReference) || !((owner = ((EReference)o).getEType()) instanceof EClass)) continue;
                result.add(o.eContainer());
                result.add(o);
            }
            Session session = SessionManager.INSTANCE.getSession((EObject)root);
            ECrossReferenceAdapter eCrossReferenceAdapter = session.getSemanticCrossReferencer();
            Collection list = eCrossReferenceAdapter.getInverseReferences((EObject)root, true);
            if (list != null && list.size() > 0) {
                for (EStructuralFeature.Setting s : list) {
                    EClass e;
                    EObject o = s.getEObject();
                    if (!(o instanceof EReference) || (e = (EClass)o.eContainer()) == null) continue;
                    result.add(e);
                    result.add(o);
                }
            }
            for (EObject current : displayedNodes) {
                if (current == null || !(current instanceof EReference)) continue;
                result.remove(current);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public Collection<EObject> showReferencesRoot(EObject eObject, Collection<EObject> displayedNodes) {
        Collection<EObject> listTemp = this.showReferences(eObject, displayedNodes);
        UniqueEList toReturn = new UniqueEList();
        for (EObject current : listTemp) {
            if (!(current instanceof EReference)) continue;
            toReturn.add(current.eContainer());
        }
        return toReturn;
    }

    public boolean toolShowPrecondition(EObject context) {
        return context instanceof EClass;
    }

    public Collection<EClass> showNeighbor(EClass eClass, DNodeList selectedClassNode) {
        Collection<EClass> displayedEClasses = this.getdisplayedEClasses(selectedClassNode);
        return this.showNeighbor(eClass, displayedEClasses);
    }

    public Collection<EClass> showNeighbor(EClass eClass, Collection<EClass> displayedEClasses) {
        if (eClass != null && displayedEClasses != null) {
            Collection<EClass> result = ShowNeighborCommandHandler.getNeighbor(eClass);
            result.removeAll(displayedEClasses);
            return result;
        }
        return Collections.emptyList();
    }

    public Collection<EClass> showRelation(EClass eClass, DNodeList selectedClassNode) {
        Collection<EClass> displayedEClasses = this.getdisplayedEClasses(selectedClassNode);
        Collection<EClass> eClassesToShow = this.showRelation(eClass, displayedEClasses);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(window.getShell(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory()));
        dialog.setMessage("Select elements :");
        dialog.setMultipleSelection(true);
        dialog.setTitle("Selection wizard");
        dialog.setElements(eClassesToShow.toArray());
        eClassesToShow.clear();
        if (dialog.open() == 0) {
            for (Object object : Arrays.asList(dialog.getResult())) {
                eClassesToShow.add((EClass)object);
            }
        }
        return eClassesToShow;
    }

    public Collection<EClass> showRelation(EClass eObject, Collection<EClass> displayedNodes) {
        if (eObject instanceof EClass) {
            EClass root = eObject;
            UniqueEList result = new UniqueEList();
            for (EObject o : root.eCrossReferences()) {
                EClassifier owner;
                if (o instanceof EClass) {
                    result.add((EClass)o);
                    continue;
                }
                if (!(o instanceof EReference) || !((owner = ((EReference)o).getEType()) instanceof EClass)) continue;
                result.add((EClass)owner);
            }
            result.addAll(root.getEAllSuperTypes());
            Session session = SessionManager.INSTANCE.getSession((EObject)root);
            ECrossReferenceAdapter eCrossReferenceAdapter = session.getSemanticCrossReferencer();
            Collection list = eCrossReferenceAdapter.getInverseReferences((EObject)root, true);
            if (list != null && list.size() > 0) {
                for (EStructuralFeature.Setting s : list) {
                    EClass e;
                    EObject o = s.getEObject();
                    if (o instanceof EClass) {
                        result.add((EClass)o);
                        continue;
                    }
                    if (!(o instanceof EReference) || (e = (EClass)o.eContainer()) == null) continue;
                    result.add(e);
                    result.addAll(this.getAllDescendants(e));
                }
            }
            result.addAll(this.getAllDescendants(root));
            result.removeAll(displayedNodes);
            return result;
        }
        return Collections.emptyList();
    }

    public Collection<EClass> getAllDescendants(EClass root) {
        Session session = SessionManager.INSTANCE.getSession((EObject)root);
        ECrossReferenceAdapter eCrossReferenceAdapter = session.getSemanticCrossReferencer();
        Collection<EClass> local = this.getDirectDescendants(root, eCrossReferenceAdapter);
        if (local.size() > 0) {
            UniqueEList result = new UniqueEList();
            result.addAll(local);
            for (EClass e : local) {
                result.addAll(this.getAllDescendants(e));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public Collection<EClass> getDirectDescendants(EClass eClass, ECrossReferenceAdapter eCrossReferenceAdapter) {
        Collection list = eCrossReferenceAdapter.getInverseReferences((EObject)eClass, true);
        if (list != null && list.size() > 0) {
            UniqueEList result = new UniqueEList();
            for (EStructuralFeature.Setting s : list) {
                if (!EcorePackage.Literals.ECLASS__ESUPER_TYPES.equals(s.getEStructuralFeature())) continue;
                EClass e = (EClass)s.getEObject();
                result.add(e);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private Collection<EClass> getdisplayedEClasses(DNodeList selectedClassNode) {
        DDiagram parentDiagram = selectedClassNode.getParentDiagram();
        EList containers = parentDiagram.getContainers();
        HashSet<EClass> displayedEClasses = new HashSet<EClass>();
        for (DDiagramElementContainer container : containers) {
            if (!(container.getTarget() instanceof EClass)) continue;
            EClass clazz = (EClass)container.getTarget();
            displayedEClasses.add(clazz);
        }
        return displayedEClasses;
    }
}

