/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramInternalQuery;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class DDiagramQuery
extends DRepresentationQuery {
    protected DDiagram dDiagram;

    public DDiagramQuery(DDiagram dDiagram) {
        super((DRepresentation)dDiagram);
        this.dDiagram = dDiagram;
    }

    public Collection<DDiagramElement> getAllDiagramElements() {
        return new DDiagramInternalQuery(this.dDiagram).getDiagramElements();
    }

    public Set<DDiagramElement> findHiddenElements() {
        HashSet result = Sets.newHashSet();
        if (this.dDiagram != null) {
            Session session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)this.dDiagram).getTarget());
            for (DDiagramElement diagramElement : this.dDiagram.getDiagramElements()) {
                if (!this.isHidden(session, diagramElement)) continue;
                result.add(diagramElement);
            }
        }
        return result;
    }

    public boolean isHidden(Session session, DDiagramElement dDiagramElement) {
        DDiagramElementQuery query = new DDiagramElementQuery(dDiagramElement);
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, this.dDiagram);
        return query.isHidden() && LayerHelper.isInActivatedLayer(mappingManager, dDiagramElement) && !query.isFiltered();
    }

    public boolean isLabelHidden(Session session, DDiagramElement dDiagramElement) {
        DDiagramElementQuery query = new DDiagramElementQuery(dDiagramElement);
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, this.dDiagram);
        return query.isLabelHidden() && LayerHelper.isInActivatedLayer(mappingManager, dDiagramElement) && !query.isFiltered();
    }

    public boolean containsHiddenElements() {
        return this.dDiagram != null && this.dDiagram.getHiddenElements() != null && !this.dDiagram.getHiddenElements().isEmpty();
    }
}

