/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.experimental.sync;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.collect.MultipleCollection;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public abstract class AbstractSynchronizerHelper {
    protected final DSemanticDiagram diagram;
    protected ModelAccessor accessor;
    protected final IInterpreter interpreter;
    protected Session session;
    protected DDiagramSynchronizer sync;
    protected boolean tool;
    private Multimap<String, EObject> candidatesMap = LinkedHashMultimap.create();

    public AbstractSynchronizerHelper(DDiagramSynchronizer sync, DSemanticDiagram diagram, ModelAccessor accessor) {
        this.diagram = diagram;
        this.accessor = accessor;
        this.session = new EObjectQuery(diagram.getTarget()).getSession();
        if (this.session == null) {
            this.session = new EObjectQuery(diagram).getSession();
        }
        this.interpreter = this.session != null ? this.session.getInterpreter() : InterpreterUtil.getInterpreter((EObject)diagram.getTarget());
        this.sync = sync;
        this.tool = false;
    }

    public static boolean isTargetDying(DSemanticDecorator decorator) {
        return decorator.getTarget() != null && (decorator.getTarget().eContainer() != null || decorator.getTarget().eResource() != null);
    }

    protected Collection<EObject> evaluateCandidateExpression(DragAndDropTarget container, DiagramElementMapping mapping) {
        return new DiagramElementMappingQuery(mapping).evaluateCandidateExpression(this.diagram, this.interpreter, container);
    }

    protected Collection<EObject> getAllCandidates(DiagramElementMapping mapping) {
        MultipleCollection semantics = new MultipleCollection();
        Option<String> domainClass = new DiagramElementMappingQuery(mapping).getDomainClass();
        if (domainClass.some()) {
            if (this.candidatesMap.containsKey(domainClass.get())) {
                semantics.addAll(this.candidatesMap.get((Object)((String)domainClass.get())));
            } else {
                for (Resource resource : this.session.getSemanticResources()) {
                    for (EObject root : resource.getContents()) {
                        semantics.addAll(this.accessor.eAllContents(root, (String)domainClass.get()));
                    }
                }
                this.candidatesMap.putAll((Object)((String)domainClass.get()), (Iterable)semantics);
            }
        }
        return semantics;
    }

    protected Collection<EObject> getPreviousSemanticsElements(DragAndDropTarget container, DiagramElementMapping mapping) {
        Collection transformed = Collections2.transform(this.sync.getPreviousDiagramElements(container, mapping), (Function)new Function<DDiagramElement, EObject>(){

            public EObject apply(DDiagramElement from) {
                return from.getTarget();
            }
        });
        return ImmutableSet.copyOf((Collection)Collections2.filter((Collection)transformed, (Predicate)Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input.eContainer() != null && input.eContainer().eResource() != null || input.eResource() != null;
            }
        })));
    }

    protected Iterable<EObject> getSemanticCandidates(DragAndDropTarget container, DiagramElementMapping mapping) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.GET_NODE_CANDIDATES_KEY);
        Iterable semantics = Lists.newArrayList();
        boolean synchronizedAndCreateElement = new DiagramElementMappingQuery(mapping).isSynchronizedAndCreateElement(this.diagram);
        boolean bl = synchronizedAndCreateElement = this.tool || synchronizedAndCreateElement;
        if (new DiagramElementMappingQuery(mapping).hasCandidatesExpression()) {
            final Collection<EObject> allCandidates = this.evaluateCandidateExpression(container, mapping);
            if (synchronizedAndCreateElement) {
                final Option<String> domainClassOption = new DiagramElementMappingQuery(mapping).getDomainClass();
                if (domainClassOption.some()) {
                    Predicate<EObject> domainClass = new Predicate<EObject>(){

                        public boolean apply(EObject input) {
                            return AbstractSynchronizerHelper.this.accessor.eInstanceOf(input, (String)domainClassOption.get());
                        }
                    };
                    semantics = Iterables.concat((Iterable)semantics, (Iterable)Iterables.filter(allCandidates, (Predicate)domainClass));
                }
            } else {
                this.sync.forceRetrieve();
                Collection<EObject> previousSemanticsElements = this.getPreviousSemanticsElements(container, mapping);
                this.sync.resetforceRetrieve();
                Predicate<EObject> stillCandidate = new Predicate<EObject>(){

                    public boolean apply(EObject input) {
                        return allCandidates.contains(input);
                    }
                };
                ImmutableSet keeped = ImmutableSet.copyOf((Collection)Collections2.filter(previousSemanticsElements, (Predicate)stillCandidate));
                semantics = Iterables.concat((Iterable)semantics, (Iterable)keeped);
            }
        } else if (synchronizedAndCreateElement) {
            semantics = Iterables.concat((Iterable)semantics, this.getAllCandidates(mapping));
        } else {
            this.sync.forceRetrieve();
            semantics = Iterables.concat((Iterable)semantics, this.getPreviousSemanticsElements(container, mapping));
            this.sync.resetforceRetrieve();
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.GET_NODE_CANDIDATES_KEY);
        return semantics;
    }

    public void setTool(boolean b) {
        this.tool = b;
    }
}

