/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.validation.description.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class ExistingDomainClassConstraint
extends AbstractConstraint {
    private static final String DOMAIN_CLASS_FEATURE = "domainClass";

    public IStatus validate(IValidationContext ctx) {
        Object[] result;
        EStructuralFeature domainClassFeature;
        EObject eObj = ctx.getTarget();
        EMFEventType eventType = ctx.getEventType();
        if (eventType == EMFEventType.NULL && this.isValidNsURI(eObj) && this.isElementContainedInAKnownMetamodel(eObj) && (domainClassFeature = eObj.eClass().getEStructuralFeature(DOMAIN_CLASS_FEATURE)) != null && (result = this.checkError(domainClassFeature, eObj)) != null) {
            return ctx.createFailureStatus(result);
        }
        return ctx.createSuccessStatus();
    }

    private Object[] checkError(EStructuralFeature domainClassFeature, EObject eObj) {
        ModelAccessor extPackage;
        String className;
        boolean canHaveNullDomainClass;
        Object[] result = null;
        Object value = eObj.eGet(domainClassFeature);
        boolean bl = canHaveNullDomainClass = eObj instanceof EdgeMapping && !((EdgeMapping)eObj).isUseDomainElement();
        if (!(value == null && !canHaveNullDomainClass || !(value instanceof String) || StringUtil.isEmpty((String)(className = (String)value)) && !canHaveNullDomainClass || StringUtil.isEmpty((String)className) || (extPackage = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(eObj)).eIsKnownType(className.trim()))) {
            result = new Object[]{value};
        }
        return result;
    }

    protected EObject getParentDescription(EObject instance) {
        if (this.isValidNsURI(instance)) {
            EObject container = instance.eContainer();
            while (container != null) {
                if (container instanceof DiagramDescription || container instanceof DiagramExtensionDescription) {
                    return container;
                }
                container = container.eContainer();
            }
        }
        return null;
    }

    private boolean isValidNsURI(EObject eObj) {
        return eObj.eClass().getEPackage().getNsURI().startsWith(ViewpointPackage.eINSTANCE.getNsURI()) || eObj.eClass().getEPackage().getNsURI().startsWith(org.eclipse.sirius.viewpoint.description.DescriptionPackage.eINSTANCE.getNsURI()) || eObj.eClass().getEPackage().getNsURI().startsWith(DescriptionPackage.eINSTANCE.getNsURI()) || eObj.eClass().getEPackage().getNsURI().startsWith(DiagramPackage.eINSTANCE.getNsURI());
    }
}

