/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.TreePackage;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.ExpandDTreeItemRunnableWithProgress;
import org.eclipse.sirius.ui.tools.internal.editor.ChangeExpandeStateRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TreeItemExpansionManager
implements Listener {
    private Tree tree;
    private Session session;
    private ModelAccessor modelAccessor;
    private IPermissionAuthority permissionAuthority;

    public TreeItemExpansionManager(Tree tree, Session session) {
        this.tree = tree;
        this.session = session;
        tree.addListener(17, (Listener)this);
        tree.addListener(18, (Listener)this);
        tree.addListener(12, (Listener)this);
        this.modelAccessor = session.getModelAccessor();
        this.permissionAuthority = this.modelAccessor.getPermissionAuthority();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 18: {
                this.handleTreeCollapse(event);
                break;
            }
            case 17: {
                this.handleTreeExpand(event);
                break;
            }
            case 12: {
                this.handleDispose();
                break;
            }
        }
    }

    private void handleTreeCollapse(Event event) {
        TreeItem treeItem;
        Object data;
        if (event.item instanceof TreeItem && (data = (treeItem = (TreeItem)event.item).getData()) instanceof DTreeItem) {
            DTreeItem dTreeItem = (DTreeItem)data;
            if (this.isEventForDTreeItemExpandable(event)) {
                this.treeExpandingCollapsingAction(treeItem, dTreeItem, false, Messages.TreeItemExpansionManager_treeCollapsing);
            } else {
                Display.getDefault().asyncExec((Runnable)new ChangeExpandeStateRunnable(treeItem, true));
            }
        }
        if (!this.isEventForDTreeItemExpandable(event)) {
            event.type = 0;
            treeItem = (TreeItem)event.item;
            Display.getDefault().asyncExec((Runnable)new ChangeExpandeStateRunnable(treeItem, true));
        }
    }

    private void handleTreeExpand(Event event) {
        TreeItem treeItem;
        Object data;
        if (event.item instanceof TreeItem && (data = (treeItem = (TreeItem)event.item).getData()) instanceof DTreeItem) {
            DTreeItem dTreeItem = (DTreeItem)data;
            if (this.isEventForDTreeItemExpandable(event)) {
                this.treeExpandingCollapsingAction(treeItem, dTreeItem, true, Messages.TreeItemExpansionManager_treeExpanding);
            } else {
                Display.getDefault().asyncExec((Runnable)new ChangeExpandeStateRunnable(treeItem, false));
            }
        }
    }

    private boolean isEventForDTreeItemExpandable(Event event) {
        TreeItem treeItem;
        Object data;
        boolean isEventForDTreeItemExpandable = true;
        if (event.item instanceof TreeItem && (data = (treeItem = (TreeItem)event.item).getData()) instanceof DTreeItem) {
            boolean canEditFeature;
            DTreeItem dTreeItem = (DTreeItem)data;
            isEventForDTreeItemExpandable = canEditFeature = this.permissionAuthority != null && this.permissionAuthority.canEditFeature((EObject)dTreeItem, TreePackage.Literals.DTREE_ITEM__EXPANDED.getName());
        }
        return isEventForDTreeItemExpandable;
    }

    private void treeExpandingCollapsingAction(final TreeItem treeItem, final DTreeItem dTreeItem, final boolean expand, final String errorMessage) {
        if (expand && !dTreeItem.isExpanded() || !expand && dTreeItem.isExpanded()) {
            Shell activeShell = this.tree.getShell();
            activeShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IProgressService ps = wb.getProgressService();
                    try {
                        ps.busyCursorWhile((IRunnableWithProgress)new ExpandDTreeItemRunnableWithProgress(TreeItemExpansionManager.this.session, dTreeItem, expand));
                    }
                    catch (InvocationTargetException e) {
                        TreeUIPlugin.INSTANCE.log(new Status(4, "org.eclipse.sirius.tree.ui", MessageFormat.format(Messages.TreeItemExpansionManager_expandOrCollaseError, errorMessage), (Throwable)e));
                    }
                    catch (InterruptedException interruptedException) {
                        Display.getDefault().asyncExec((Runnable)new ChangeExpandeStateRunnable(treeItem, !expand));
                    }
                }
            });
        }
    }

    private void handleDispose() {
        if (this.tree != null) {
            this.tree.removeListener(12, (Listener)this);
            this.tree.removeListener(18, (Listener)this);
            this.tree.removeListener(17, (Listener)this);
        }
        this.tree = null;
        this.session = null;
    }
}

