/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.AbstractPage;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.Page;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.Section;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.ViewpointActivityExplorer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Aspect;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint;

public class ActivityExplorerAspectHelper {
    public static final String PROVIDER_PAGES_EXT = "org.eclipse.amalgam.explorer.activity.ui.pagesProvider";
    public static final String PROVIDER_SECTIONS_EXT = "org.eclipse.amalgam.explorer.activity.ui.sectionsProvider";
    public static final String ATT_ID = "id";
    public static final String ATT_TITLE = "title";
    public static final String ATT_TABNAME = "tabName";
    public static final String ATT_NAME = "name";
    public static final String SECTION = "Section";
    private static final int PAGE_TYPE = 1;
    private static final int SECTION_TYPE = 2;

    public static List<String> getUsedViewpointPagesIDs(Viewpoint model) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<Viewpoint> viewpoints = new HashSet<Viewpoint>();
        ActivityExplorerAspectHelper.collectAllviewpoints(model, viewpoints);
        for (Viewpoint viewpoint : viewpoints) {
            List<String> viewpointPagesIDs = ActivityExplorerAspectHelper.getViewpointPagesIDs(viewpoint);
            if (viewpointPagesIDs.isEmpty()) continue;
            result.addAll(viewpointPagesIDs);
        }
        return result;
    }

    private static void collectAllviewpoints(Viewpoint viewpoint, Set<Viewpoint> result) {
        if (viewpoint != null) {
            List<Viewpoint> viewpoints = ActivityExplorerAspectHelper.getDirectViewpointsOf(viewpoint);
            result.addAll(viewpoints);
            for (Viewpoint v : viewpoints) {
                ActivityExplorerAspectHelper.collectAllviewpoints(v, result);
            }
        }
    }

    private static List<Viewpoint> getDirectViewpointsOf(Viewpoint model) {
        EList viewpoints = model.getUseViewpoint();
        EList parents = model.getParents();
        EList dependencies = model.getDependencies();
        ArrayList<Viewpoint> viewpointsCopy = new ArrayList<Viewpoint>();
        viewpointsCopy.addAll((Collection<Viewpoint>)viewpoints);
        viewpointsCopy.addAll((Collection<Viewpoint>)parents);
        viewpointsCopy.addAll((Collection<Viewpoint>)dependencies);
        return viewpointsCopy;
    }

    public static List<String> getUsedViewpointSectionsIDs(Viewpoint model) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<Viewpoint> viewpoints = new HashSet<Viewpoint>();
        ActivityExplorerAspectHelper.collectAllviewpoints(model, viewpoints);
        for (Viewpoint viewpoint : viewpoints) {
            List<String> vewpointSectionsIDs = ActivityExplorerAspectHelper.getViewpointSectionsIDs(viewpoint);
            if (vewpointSectionsIDs.isEmpty()) continue;
            result.addAll(vewpointSectionsIDs);
        }
        return result;
    }

    public static List<String> getViewpointPagesIDs(Viewpoint viewpoint) {
        ArrayList<String> result = new ArrayList<String>();
        List<AbstractPage> aExPages = ActivityExplorerAspectHelper.getAExPages(viewpoint, true);
        for (AbstractPage abstractpage : aExPages) {
            if (!(abstractpage instanceof Page)) continue;
            result.add(((Page)abstractpage).getActivityExplorerItemID());
        }
        return result;
    }

    public static final List<AbstractPage> getAExPages(Viewpoint viewpoint, boolean includePageExtensions) {
        ArrayList<AbstractPage> pages = new ArrayList<AbstractPage>();
        ViewpointActivityExplorer aExAspect = ActivityExplorerAspectHelper.getAExAspect(viewpoint);
        if (aExAspect == null) {
            return pages;
        }
        EList ownedPages = aExAspect.getOwnedPages();
        for (AbstractPage abstractPage : ownedPages) {
            if (!(abstractPage instanceof Page) && !includePageExtensions) continue;
            pages.add(abstractPage);
        }
        return pages;
    }

    public static ViewpointActivityExplorer getAExAspect(Viewpoint viewpoint) {
        EList vp_Aspects = viewpoint.getVP_Aspects();
        if (!vp_Aspects.isEmpty()) {
            for (Aspect aspect : vp_Aspects) {
                if (!(aspect instanceof ViewpointActivityExplorer)) continue;
                return (ViewpointActivityExplorer)aspect;
            }
        }
        return null;
    }

    public static List<String> getViewpointSectionsIDs(Viewpoint viewpoint) {
        ArrayList<String> result = new ArrayList<String>();
        List<AbstractPage> aExPages = ActivityExplorerAspectHelper.getAExPages(viewpoint, true);
        for (AbstractPage abstractpage : aExPages) {
            EList ownedSections = abstractpage.getOwnedSections();
            for (Section section : ownedSections) {
                result.add(section.getActivityExplorerItemID());
            }
        }
        return result;
    }

    public static String getPageName(Viewpoint viewpoint, String id) {
        EList useViewpoints = viewpoint.getUseViewpoint();
        for (Viewpoint vp : useViewpoints) {
            ViewpointActivityExplorer aExAspect = ActivityExplorerAspectHelper.getAExAspect(vp);
            EList ownedPages = aExAspect.getOwnedPages();
            for (AbstractPage p : ownedPages) {
                if (!(p instanceof Page) || !((Page)p).getActivityExplorerItemID().equals(id)) continue;
                String name = ((Page)p).getName();
                if (name == null || name.isEmpty()) {
                    return ((Page)p).getTabName();
                }
                return name;
            }
        }
        return null;
    }

    public static String getPageName(String id) {
        IConfigurationElement[] config = ActivityExplorerAspectHelper.getExtensionsFor(PROVIDER_PAGES_EXT);
        if (config.length != 0) {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                String _id = iConfigurationElement.getAttribute(ATT_ID);
                if (_id != null && !_id.isEmpty() && _id.equals(id)) {
                    return ActivityExplorerAspectHelper.getConfigurationName(iConfigurationElement, 1);
                }
                ++n2;
            }
        }
        return null;
    }

    private static IConfigurationElement[] getExtensionsFor(String id) {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(id);
        return config;
    }

    private static String getConfigurationName(IConfigurationElement conf, int type) {
        String name = null;
        switch (type) {
            case 1: {
                name = conf.getAttribute(ATT_TITLE);
                if (name == null || name.isEmpty()) {
                    return conf.getAttribute(ATT_TABNAME);
                }
                return name;
            }
            case 2: {
                return conf.getAttribute(ATT_NAME);
            }
        }
        return null;
    }

    public static String getSectionName(Viewpoint viewpoint, String extendedSectionId) {
        EList useViewpoints = viewpoint.getUseViewpoint();
        for (Viewpoint vp : useViewpoints) {
            ViewpointActivityExplorer aExAspect = ActivityExplorerAspectHelper.getAExAspect(vp);
            EList ownedPages = aExAspect.getOwnedPages();
            for (AbstractPage _p : ownedPages) {
                EList ownedSections = _p.getOwnedSections();
                for (Section _s : ownedSections) {
                    String id = _s.getActivityExplorerItemID();
                    if (id == null || id.isEmpty() || !id.equals(extendedSectionId)) continue;
                    return _s.getName();
                }
            }
        }
        return null;
    }

    public static String getSectionName(String extendedSectionId) {
        block6: {
            IConfigurationElement[] config;
            block5: {
                config = ActivityExplorerAspectHelper.getExtensionsFor(PROVIDER_SECTIONS_EXT);
                if (config.length == 0) break block5;
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    String _id = iConfigurationElement.getAttribute(ATT_ID);
                    if (_id != null && !_id.isEmpty() && _id.equals(extendedSectionId)) {
                        return ActivityExplorerAspectHelper.getConfigurationName(iConfigurationElement, 2);
                    }
                    ++n2;
                }
                break block6;
            }
            config = ActivityExplorerAspectHelper.getExtensionsFor(PROVIDER_PAGES_EXT);
            if (config.length == 0) break block6;
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n3 = 0;
            while (n3 < n) {
                IConfigurationElement[] children;
                IConfigurationElement _configPage = iConfigurationElementArray[n3];
                IConfigurationElement[] iConfigurationElementArray2 = children = _configPage.getChildren(SECTION);
                int n4 = children.length;
                int n5 = 0;
                while (n5 < n4) {
                    IConfigurationElement _sectionChild = iConfigurationElementArray2[n5];
                    String id = _sectionChild.getAttribute(ATT_ID);
                    if (id.equals(extendedSectionId)) {
                        return ActivityExplorerAspectHelper.getConfigurationName(_sectionChild, 2);
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        return null;
    }
}

