/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.core.task;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationElement;
import org.eclipse.egf.portfolio.genchain.tools.ui.actions.BuildApplicationHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.adapter.TaskProductionAdapter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.core.utils.GenchainAdditionsManager;

public class LvpsGenChainModelLauncherTask
extends TaskProductionAdapter {
    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String lvpsProjectName = (String)productionContext.getInputValue((Object)"root.project.name", String.class);
        String lvpsShortName = (String)productionContext.getInputValue((Object)"short.name", String.class);
        String modelFolder = (String)productionContext.getInputValue((Object)"model.folder", String.class);
        Boolean buildViewpoint = (Boolean)productionContext.getInputValue((Object)"build.viewpoint", Boolean.class);
        buildViewpoint = buildViewpoint == null ? false : buildViewpoint;
        GenerationChain genchain = this.getGenerationchain(lvpsProjectName, lvpsShortName, modelFolder);
        GenchainAdditionsManager.INSTANCE.addAdditions(genchain);
        try {
            genchain.eResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (buildViewpoint.booleanValue()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(lvpsProjectName);
            IFile modelFile = project.getFile(String.valueOf(modelFolder) + "/" + lvpsShortName + ".generationchain");
            URI modelURI = URI.createPlatformPluginURI((String)modelFile.getFullPath().toString(), (boolean)false);
            class VpdslOnlyBuildApplicationHelper
            extends BuildApplicationHelper {
                VpdslOnlyBuildApplicationHelper() {
                }

                public void onlyBuild(URI fcoreURI) {
                    TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
                    this.generationChain = (GenerationChain)resourceSet.getResource(fcoreURI, true).getContents().get(0);
                    super.createAfterJob().schedule();
                }

                protected String computeFcoreOutputPath(GenerationChain generationChain) {
                    return String.valueOf(generationChain.getFactoryComponentName()) + ".fc" + this.computeFcoreRelativePath(generationChain);
                }
            }
            VpdslOnlyBuildApplicationHelper onlyBuilder = new VpdslOnlyBuildApplicationHelper();
            onlyBuilder.onlyBuild(modelURI);
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected GenerationChain getGenerationchain(String projectName, String shortName, String modelFolder) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile modelFile = project.getFile(String.valueOf(modelFolder) + "/" + shortName + ".generationchain");
        URI modelURI = URI.createURI((String)modelFile.getLocationURI().toString());
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(modelURI);
        try {
            r.load(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (r != null && r.isLoaded()) {
            GenerationChain rootGenChainElement = (GenerationChain)r.getContents().get(0);
            for (GenerationElement generationElement : rootGenChainElement.getElements()) {
                if (!(generationElement instanceof GenerationChain)) continue;
                return (GenerationChain)generationElement;
            }
        }
        return null;
    }
}

