/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.registry;

import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.polarsys.kitalpha.resourcereuse.helper.Constants;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReader;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.registry.ModelBasedRegistry;
import org.polarsys.kitalpha.resourcereuse.registry.ResourceRegistry;

public abstract class ModelBasedReader
implements Constants,
ResourceReader {
    protected ModelBasedRegistry registry;

    private Resource createResource(IPluginElement element) {
        Resource res = new Resource();
        String symbolicName = element.getPluginModel().getBundleDescription().getSymbolicName();
        res.setProviderSymbolicName(symbolicName);
        res.setProviderLocation(this.getLocation());
        IPluginAttribute attribute = element.getAttribute("id");
        if (attribute != null) {
            res.setId(attribute.getValue());
        }
        if ((attribute = element.getAttribute("name")) != null) {
            res.setName(attribute.getValue());
        }
        if ((attribute = element.getAttribute("weight")) != null) {
            res.setWeight(Integer.parseInt(attribute.getValue()));
        }
        if ((attribute = element.getAttribute("domain")) != null) {
            res.setDomain(attribute.getValue());
        }
        if ((attribute = element.getAttribute("description")) != null) {
            res.setDescription(attribute.getValue());
        }
        if ((attribute = element.getAttribute("version")) != null) {
            res.setVersion(attribute.getValue());
        }
        if ((attribute = element.getAttribute("path")) != null) {
            res.setPath(attribute.getValue());
        }
        if ((attribute = element.getAttribute("tags")) != null) {
            String tags = attribute.getValue();
            String[] stringArray = tags.split(", ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                res.getTags().add(tag);
                ++n2;
            }
        }
        return res;
    }

    protected abstract Location getLocation();

    protected void handleExtensions(IExtensions extensions) {
        String bundleId = extensions.getPluginBase().getId();
        this.registry.clear(bundleId);
        IPluginExtension[] iPluginExtensionArray = extensions.getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            this.handleExtension(extension);
            ++n2;
        }
    }

    private void handleExtension(IPluginExtension extension) {
        String bundleId = extension.getPluginBase().getId();
        IPluginObject[] iPluginObjectArray = extension.getChildren();
        int n = iPluginObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginObject obj = iPluginObjectArray[n2];
            if ("org.polarsys.kitalpha.resourcereuse.concerns".equals(extension.getPoint()) && obj instanceof IPluginElement) {
                IPluginElement element = (IPluginElement)obj;
                String concernName = element.getAttribute("name").getValue();
                String user = element.getAttribute("userResourceId").getValue();
                String used = element.getAttribute("usedResourceId").getValue();
                this.registry.addConcern(bundleId, concernName, user, used);
            } else if ("org.polarsys.kitalpha.resourcereuse.resources".equals(extension.getPoint()) && obj instanceof IPluginElement) {
                IPluginElement elem = (IPluginElement)obj;
                Resource res = this.createResource(elem);
                this.registry.addResource(bundleId, res);
            }
            ++n2;
        }
    }

    @Override
    public ResourceRegistry readResources(ResourceRegistry parent) {
        this.registry = new ModelBasedRegistry(parent, this);
        IPluginModelBase[] iPluginModelBaseArray = this.getModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            this.handleExtensions(model.getExtensions());
            ++n2;
        }
        return this.registry;
    }

    protected abstract IPluginModelBase[] getModels();
}

