/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.share.resource.loading;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.model.common.share.Messages;

public class LoadResource {
    private IFile airdResource;
    private IProgressMonitor monitor;
    Resource resource;

    public LoadResource(IFile airdResource) {
        this.airdResource = airdResource;
        this.monitor = null;
        this.resource = null;
    }

    public LoadResource(IFile airdResource, IProgressMonitor monitor) {
        this.airdResource = airdResource;
        this.monitor = monitor;
        this.resource = null;
    }

    public IFile getAirdResource() {
        return this.airdResource;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public Resource getResource() {
        if (this.resource != null && this.resource.isLoaded()) {
            return this.resource;
        }
        URI resourceURI = URI.createPlatformResourceURI((String)this.getAirdResource().getFullPath().toString(), (boolean)false);
        this.resource = this.getResourceSet(this.getMonitor()).getResource(resourceURI, true);
        return this.resource;
    }

    private ResourceSetImpl getResourceSet(final IProgressMonitor monitor) {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl(){

            protected void demandLoadHelper(Resource resource) {
                if (monitor != null) {
                    monitor.subTask(String.valueOf(Messages.LOADING_RESOURCE) + " " + resource.getURI());
                }
                super.demandLoadHelper(resource);
            }
        };
        resourceSetImpl.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        return resourceSetImpl;
    }
}

