/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.IViewpointTreeDescription;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.ViewpointTreeContainer;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.ViewpointTreeDescription;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.helpers.ViewpointsSearcherHelper;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class ViewpointTreeBuilder {
    private ViewpointTreeContainer treeContainer = new ViewpointTreeContainer();
    private Resource[] viewpointResources = ViewpointsSearcherHelper.getAllViewpoints();

    public ViewpointTreeContainer getViewpointTreeContainer(Map<String, Collection<String>> relationships) {
        this.treeContainer.dispose();
        Collection<Resource> filtredResources = this.filterViewpointResources(this.viewpointResources, relationships);
        Collection<IViewpointTreeDescription> vpd_set = this.buildViewpointTreeDescriptions(filtredResources, relationships);
        for (IViewpointTreeDescription vpd : vpd_set) {
            Viewpoint viewpoint = this.getViewpointRootEObject(vpd.getRootEObject());
            this.computeViewpointTreeDescriptionAggregations(vpd, vpd_set, viewpoint);
            this.computeViewpointTreeDescriptionParents(vpd, vpd_set, relationships, viewpoint);
        }
        this.initVpdContainerRoots(vpd_set);
        return this.treeContainer;
    }

    private Collection<Resource> filterViewpointResources(Resource[] resources, Map<String, Collection<String>> relationship) {
        HashSet<Resource> usedViewpointResources = new HashSet<Resource>();
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource2 = resourceArray[n2];
            Viewpoint current = this.getViewpointRootEObject(resource2.getPath());
            EList ePackages = current.getMetamodel().getModels();
            for (EPackage ePackage : ePackages) {
                if (!relationship.containsKey(ePackage.getNsURI())) continue;
                usedViewpointResources.add(resource2);
                break;
            }
            ++n2;
        }
        return usedViewpointResources;
    }

    private Collection<IViewpointTreeDescription> buildViewpointTreeDescriptions(Collection<Resource> filtredResources, Map<String, Collection<String>> relationships) {
        HashSet<IViewpointTreeDescription> viewpointTreeDescriptions = new HashSet<IViewpointTreeDescription>();
        for (Resource resource : filtredResources) {
            Viewpoint current = this.getViewpointRootEObject(resource.getPath());
            EList ePackages = current.getMetamodel().getModels();
            IViewpointTreeDescription vpd = this.createNewViewpointDescription(resource);
            for (EPackage ePackage : ePackages) {
                vpd.getViewpointNsUri().add(ePackage.getNsURI());
            }
            viewpointTreeDescriptions.add(vpd);
        }
        return viewpointTreeDescriptions;
    }

    private IViewpointTreeDescription createNewViewpointDescription(Resource resource) {
        String viewpoint_name = resource.getName();
        String viewpoint_id = resource.getId();
        String viewpoint_ePath = resource.getPath();
        ViewpointTreeDescription vpd = new ViewpointTreeDescription(viewpoint_name, viewpoint_id, viewpoint_ePath);
        return vpd;
    }

    private Collection<IViewpointTreeDescription> searchViewpointTreeDescriptions(String nsuri, Collection<IViewpointTreeDescription> vpd_set) {
        HashSet<IViewpointTreeDescription> vpdFound = new HashSet<IViewpointTreeDescription>();
        if (vpd_set != null) {
            for (IViewpointTreeDescription tmp : vpd_set) {
                Collection<String> nsUris = tmp.getViewpointNsUri();
                if (!nsUris.contains(nsuri)) continue;
                vpdFound.add(tmp);
            }
        }
        return vpdFound;
    }

    private void computeViewpointTreeDescriptionAggregations(IViewpointTreeDescription vpd, Collection<IViewpointTreeDescription> vpd_set, Viewpoint eVpRoot) {
        if (vpd_set == null) {
            return;
        }
        EList dependencies = eVpRoot.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            for (Viewpoint viewpoint : dependencies) {
                EList ePackages = viewpoint.getMetamodel().getModels();
                for (EPackage ePackage : ePackages) {
                    String nsuri = ePackage.getNsURI();
                    Collection<IViewpointTreeDescription> vpdDependencies = this.searchViewpointTreeDescriptions(nsuri, vpd_set);
                    if (vpdDependencies == null || vpdDependencies.isEmpty()) continue;
                    for (IViewpointTreeDescription dependency : vpdDependencies) {
                        vpd.addDependency(dependency);
                    }
                }
            }
        }
    }

    private void computeViewpointTreeDescriptionParents(IViewpointTreeDescription vpd, Collection<IViewpointTreeDescription> vpd_set, Map<String, Collection<String>> relationships, Viewpoint eVpRoot) {
        if (vpd_set == null) {
            return;
        }
        EList parents = eVpRoot.getParents();
        if (parents != null && !parents.isEmpty()) {
            for (Viewpoint viewpoint : parents) {
                EList ePackages = viewpoint.getMetamodel().getModels();
                for (EPackage ePackage : ePackages) {
                    String nsUri = ePackage.getNsURI();
                    Collection<IViewpointTreeDescription> vpd_parents = this.searchViewpointTreeDescriptions(nsUri, vpd_set);
                    if (vpd_parents == null || vpd_parents.isEmpty()) continue;
                    for (IViewpointTreeDescription vpd_parent : vpd_parents) {
                        vpd.addParent(vpd_parent);
                        vpd_parent.addChild(vpd);
                    }
                }
            }
        }
        Collection<String> vpd_nsuri = vpd.getViewpointNsUri();
        for (String nsUri : vpd_nsuri) {
            Collection<String> uses = relationships.get(nsUri);
            for (String used_nsUri : uses) {
                Collection<IViewpointTreeDescription> used_vpd = this.searchViewpointTreeDescriptions(used_nsUri, vpd_set);
                for (IViewpointTreeDescription usedVpd : used_vpd) {
                    vpd.addParent(usedVpd);
                    usedVpd.addChild(vpd);
                    vpd.addUsedViewpoint(usedVpd);
                }
            }
        }
    }

    private void initVpdContainerRoots(Collection<IViewpointTreeDescription> vpd_set) {
        for (IViewpointTreeDescription vpd : vpd_set) {
            if (!vpd.getParents().isEmpty()) continue;
            this.treeContainer.getRoots().add(vpd);
        }
    }

    private Viewpoint getViewpointRootEObject(String path) {
        if (this.checkString(path)) {
            URI uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            return (Viewpoint)resourceSet.getEObject(uri, true);
        }
        return null;
    }

    private boolean checkString(String s) {
        return s != null && !s.equals("");
    }
}

