/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class ViewpointRelationshipHelper {
    public static Map<String, Collection<String>> getUsedRelationship(Resource[] resources) {
        return ViewpointRelationshipHelper.discouverUsedRelationShips(resources);
    }

    public static Collection<EList<EPackage>> collectAllViewpointsEPackages(Resource[] resources) {
        HashSet<EList<EPackage>> viewpointsEPackages = new HashSet<EList<EPackage>>();
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            String ePath = resource.getPath();
            Viewpoint currentViewpoints = ViewpointRelationshipHelper.getViewpointRootEObject(ePath);
            EList ePackages = currentViewpoints.getMetamodel().getModels();
            viewpointsEPackages.add((EList<EPackage>)ePackages);
            ++n2;
        }
        return viewpointsEPackages;
    }

    public static Map<String, Collection<String>> discouverUsedRelationShips(Resource[] resources) {
        HashMap<String, Collection<String>> relationshipResult = new HashMap<String, Collection<String>>();
        Collection<EList<EPackage>> ePackageList = ViewpointRelationshipHelper.collectAllViewpointsEPackages(resources);
        for (EList<EPackage> eList : ePackageList) {
            for (EPackage ePackage : eList) {
                ViewpointRelationshipHelper.discoverDependeciesOfEPackage(ePackage, ePackageList, relationshipResult, false);
            }
        }
        return relationshipResult;
    }

    public static void discoverDependeciesOfEPackage(EPackage ePackage, Collection<EList<EPackage>> allViewpointEpackages, Map<String, Collection<String>> dependencies, boolean deepDependencies) {
        if (ePackage != null) {
            EList ePackageEClassifiers = ePackage.getEClassifiers();
            for (EClassifier eClassifier : ePackageEClassifiers) {
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                ViewpointRelationshipHelper.discoverEClassDependencies(eClass, allViewpointEpackages, dependencies, deepDependencies);
            }
        }
    }

    public static void discoverEClassDependencies(EClass eClass, Collection<EList<EPackage>> allViewpointEpackages, Map<String, Collection<String>> dependencies, boolean deepDependencies) {
        EList annotations;
        EList refs;
        EList attributes;
        EList superTypes;
        String nsUri = eClass.getEPackage().getNsURI();
        if (!dependencies.keySet().contains(nsUri) && ViewpointRelationshipHelper.ePackageIsIn(nsUri, allViewpointEpackages)) {
            dependencies.put(nsUri, new HashSet());
        }
        if ((superTypes = eClass.getESuperTypes()) != null && !superTypes.isEmpty()) {
            for (EClass type : superTypes) {
                String nsUri2 = type.getEPackage().getNsURI();
                if (nsUri.equals(nsUri2) || !ViewpointRelationshipHelper.ePackageIsIn(nsUri2, allViewpointEpackages)) continue;
                dependencies.get(nsUri).add(nsUri2);
            }
        }
        if ((attributes = eClass.getEAllAttributes()) != null && !attributes.isEmpty()) {
            for (EAttribute attr : attributes) {
                Iterator type;
                String nsUri2;
                if (attr.isDerived() || attr.isVolatile() || attr.isTransient() || nsUri.equals(nsUri2 = (type = attr.getEType()).getEPackage().getNsURI()) || !ViewpointRelationshipHelper.ePackageIsIn(nsUri2, allViewpointEpackages)) continue;
                dependencies.get(nsUri).add(nsUri2);
            }
        }
        if ((refs = eClass.getEAllReferences()) != null && !refs.isEmpty()) {
            for (EReference ref : refs) {
                EClassifier type;
                String nsUri2;
                if (ref.isDerived() || ref.isVolatile() || ref.isTransient() || nsUri.equals(nsUri2 = (type = ref.getEType()).getEPackage().getNsURI()) || !ViewpointRelationshipHelper.ePackageIsIn(nsUri2, allViewpointEpackages)) continue;
                dependencies.get(nsUri).add(nsUri2);
            }
        }
        if ((annotations = eClass.getEAnnotations()) != null && !annotations.isEmpty()) {
            for (EAnnotation ann : annotations) {
                EMap details = ann.getDetails();
                for (String key : details.keySet()) {
                    String value = (String)details.get((Object)key);
                    if (nsUri.equals(value) || !ViewpointRelationshipHelper.ePackageIsIn(value, allViewpointEpackages)) continue;
                    dependencies.get(nsUri).add(value);
                }
            }
        }
    }

    private static boolean ePackageIsIn(String nsUri2, Collection<EList<EPackage>> allViewpointEpackages) {
        for (EList<EPackage> eList : allViewpointEpackages) {
            for (EPackage ePackage : eList) {
                String nsUri = ePackage.getNsURI();
                if (nsUri == null || !nsUri.equals(nsUri2)) continue;
                return true;
            }
        }
        return false;
    }

    private static Viewpoint getViewpointRootEObject(String path) {
        if (ViewpointRelationshipHelper.checkString(path)) {
            URI uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            return (Viewpoint)resourceSet.getEObject(uri, true);
        }
        return null;
    }

    private static boolean checkString(String s) {
        return s != null && !s.equals("");
    }

    public static boolean detectCycle(Map<String, Collection<String>> relationships) {
        boolean isCycleDetected = false;
        block0: for (String uri : relationships.keySet()) {
            Collection<String> tmp = relationships.get(uri);
            for (String uri2 : tmp) {
                Collection<String> tmp2;
                if (!relationships.keySet().contains(uri2) || !(tmp2 = relationships.get(uri2)).contains(uri)) continue;
                isCycleDetected = true;
                break block0;
            }
        }
        return isCycleDetected;
    }
}

