/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.profiler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerEvent;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerListener;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTask;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTaskRegistry;
import org.eclipse.sirius.ext.base.Option;

public class TimeProfiler {
    public static final ProfilerTaskRegistry PROFILER_TASK_REGISTRY = new ProfilerTaskRegistry();
    protected static final int ALIGNMENT_LINE_SIZE = 150;
    protected Map<ProfilerTask, Long> times;
    protected boolean isActive;
    private Map<ProfilerTask, Integer> countTasks;
    private Map<ProfilerTask, Long> startTimes;
    private final List<ProfilerListener> listeners = new ArrayList<ProfilerListener>(3);

    public TimeProfiler() {
        this.init();
    }

    private Long now() {
        return new Date().getTime();
    }

    private void initMaps() {
        this.times = new HashMap<ProfilerTask, Long>();
        this.startTimes = new HashMap<ProfilerTask, Long>();
        this.countTasks = new HashMap<ProfilerTask, Integer>();
    }

    public void init() {
        this.initMaps();
    }

    public void startWork(String profilerTaskKey) {
        Option<ProfilerTask> option;
        if (this.isActive && (option = PROFILER_TASK_REGISTRY.get(profilerTaskKey)).some()) {
            this.startWork((ProfilerTask)option.get());
        }
    }

    public void startWork(ProfilerTask task) {
        if (this.isActive) {
            this.startTimes.put(task, this.now());
            Integer countI = this.countTasks.get(task);
            int count = countI == null ? 0 : countI;
            this.countTasks.put(task, count + 1);
        }
    }

    public void stopWork(String profilerTaskKey) {
        Option<ProfilerTask> option;
        if (this.isActive && (option = PROFILER_TASK_REGISTRY.get(profilerTaskKey)).some()) {
            this.stopWork((ProfilerTask)option.get());
        }
    }

    public void stopWork(ProfilerTask task) {
        if (this.isActive) {
            long endTime = this.now();
            if (!this.startTimes.containsKey(task)) {
                this.startTimes.put(task, this.now());
            }
            long startTime = this.now();
            if (this.startTimes.containsKey(task)) {
                startTime = this.startTimes.get(task);
            }
            long duration = endTime - startTime;
            if (!this.times.containsKey(task)) {
                this.times.put(task, 0L);
            }
            long oldDuration = this.times.get(task);
            this.times.put(task, oldDuration + duration);
            this.startTimes.remove(task);
        }
    }

    public long getTimeEllapsed(ProfilerTask task) {
        if (this.isActive && this.times.containsKey(task)) {
            return this.times.get(task);
        }
        return 0L;
    }

    public int getCountTask(String profilerTaskKey) {
        Option<ProfilerTask> option = PROFILER_TASK_REGISTRY.get(profilerTaskKey);
        if (option.some()) {
            return this.getCountTask((ProfilerTask)option.get());
        }
        return 0;
    }

    public int getCountTask(ProfilerTask task) {
        Integer count = this.countTasks.get(task);
        return count == null ? 0 : count;
    }

    public Set<ProfilerTask> getTasks() {
        return this.times.keySet();
    }

    public Set<ProfilerTask> getRunningTasks() {
        return this.startTimes.keySet();
    }

    public String getStatus() {
        int defaultLineLength = 100;
        StringBuffer result = new StringBuffer(this.times.keySet().size() * defaultLineLength);
        if (this.isActive) {
            for (ProfilerTask name : this.times.keySet()) {
                String line = "\n  " + name + "  :";
                line = String.valueOf(line) + this.getMissingSpacesForAlignment(line, 150);
                line = String.valueOf(line) + this.times.get(name).toString();
                line = String.valueOf(line) + this.getMissingSpacesForAlignment(line, 160);
                line = String.valueOf(line) + " ms";
                result.append(line);
            }
        }
        return result.toString();
    }

    protected String getMissingSpacesForAlignment(String original, int alignmentSize) {
        int currentSize = original.length();
        StringBuffer result = new StringBuffer();
        while (currentSize < alignmentSize) {
            result.append(' ');
            ++currentSize;
        }
        return new String(result);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isProfilerActive) {
        this.isActive = isProfilerActive;
    }

    public void addProfilerListener(ProfilerListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException(Messages.TimeProfiler_nullListener);
        }
        this.listeners.add(listener);
    }

    public void removeProfilerListener(ProfilerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireProfilerReinited() {
        ProfilerEvent event = new ProfilerEvent(null, this);
        for (ProfilerListener profilerListener : this.listeners) {
            profilerListener.profilerReinited(event);
        }
    }

    protected void fireTaskStarted(ProfilerTask task) {
        ProfilerEvent event = new ProfilerEvent(task, this);
        for (ProfilerListener profilerListener : this.listeners) {
            profilerListener.taskStarted(event);
        }
    }

    protected void fireTaskStopped(ProfilerTask task) {
        ProfilerEvent event = new ProfilerEvent(task, this);
        for (ProfilerListener profilerListener : this.listeners) {
            profilerListener.taskStopped(event);
        }
    }
}

