/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.util;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.preferences.kitalphaPreferences.PreferencesConstants;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.utils.NamesValidityChecker;

public class WizardsUtil {
    public static final String COPYRIGHT_KITALPHA = "PolarSys";
    public static final String GENERATOR_SPECILIZATION_EXTENSION_ID = "org.polarsys.kitalpha.ad.ta.definition";
    public static final String GENERATOR_SPECILIZATION_EXTENSION_POINT_NAME = "definition";
    public static final String GENERATOR_SPECILIZATION_EXTENSION_POINT_ATTRIBUTE = "name";
    private static final String SPACE = " ";
    private static final String QUOTES = "\"";

    public static String getInitialSpecContent(String shortName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Viewpoint " + shortName + " {\n" + "\tname: \"" + shortName + "\"\n" + "\tData " + shortName + ".data" + "\n" + "\tConfiguration " + shortName + ".conf" + "\n" + "}";
        return fileContent;
    }

    public static String getInitialBuildContent(String shortName) {
        String projectTargetPlatform = PreferencesConstants.getBuildPreferences((String)"target-platform-pref");
        String projectRootFeatures = PreferencesConstants.getBuildPreferences((String)"features-root-path-pref");
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Build " + shortName + ".build" + " {\n" + "\ttarget-platform: " + QUOTES + projectTargetPlatform + QUOTES + "\n" + "\trepository: git " + "\"http://shortName" + "/" + shortName + ".git\"" + "\n" + "\tfeatures: " + projectRootFeatures + "." + shortName + ".feature" + "\n" + "}";
        return fileContent;
    }

    public static String getInitialBuildContent(String shortName, String fileName) {
        String projectTargetPlatform = "C://eclipse.exe";
        String projectRootFeatures = PreferencesConstants.getBuildPreferences((String)"features-root-path-pref");
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Build " + fileName + " {\n" + "\ttarget-platform: " + QUOTES + projectTargetPlatform + QUOTES + "\n" + "\trepository: git " + "\"http://shortName" + "/" + shortName + ".git\"" + "\n" + "\tfeatures: " + projectRootFeatures + "." + shortName + ".feature" + "\n" + "}";
        return fileContent;
    }

    public static String getInitialConfigurationContent(String shortName, String targetApplication, String rootProjectName, String nsURI) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Configuration " + shortName + ".conf" + " {\n";
        fileContent = targetApplication != null && targetApplication.contains(SPACE) ? String.valueOf(fileContent) + "\ttarget " + QUOTES + targetApplication + QUOTES + "\n" : String.valueOf(fileContent) + "\ttarget " + targetApplication + "\n";
        fileContent = String.valueOf(fileContent) + "\tproject " + rootProjectName + "\n" + "\tnsuri " + QUOTES + nsURI + QUOTES + "\n";
        fileContent = String.valueOf(fileContent) + "\tgeneration {\n\t\tdata (\n\t\t\tModel: true\n\t\t\tEdit: true\n\t\t\tEditor: false\n\t\t\tTest: false\n\t\t\tJavadoc: false\n\t\t\tOverwriteEcore: true\n\t\t)\n\t\tdiagram (\n\t\t\tOverwriteOdesign: true\n\t\t)\n\t\tdocumentation (\n\t\t\tEcoreToHtml: false\n\t\t)\n\t}\n}\n";
        return fileContent;
    }

    public static String getInitialConfigurationContent(String shortName, String fileName, String targetApplication, String rootProjectName, String nsURI) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Configuration " + fileName + " {\n";
        fileContent = targetApplication != null && targetApplication.contains(SPACE) ? String.valueOf(fileContent) + "\ttarget " + QUOTES + targetApplication + QUOTES + "\n" : String.valueOf(fileContent) + "\ttarget " + targetApplication + "\n";
        fileContent = String.valueOf(fileContent) + "\tproject " + rootProjectName + "\n" + "\tproject " + rootProjectName + "\n" + "\tnsuri " + QUOTES + nsURI + QUOTES + "\n";
        fileContent = String.valueOf(fileContent) + "\tgeneration {\n\t\tdata (\n\t\t\tModel: true\n\t\t\tEdit: true\n\t\t\tEditor: false\n\t\t\tTest: false\n\t\t\tJavadoc: false\n\t\t\tOverwriteEcore: true\n\t\t)\n\t\tdiagram (\n\t\t\tOverwriteOdesign: true\n\t\t)\n\t\tdocumentation (\n\t\t\tEcoreToHtml: false\n\t\t)\n\t}\n}\n";
        return fileContent;
    }

    public static String getInitialDataContent(String shortName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Data " + shortName + ".data" + " {\n\n" + "}";
        return fileContent;
    }

    public static String getInitialDataContent(String shortName, String fileName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Data " + fileName + " {\n\n" + "}";
        return fileContent;
    }

    public static String getInitialDiagramContent(String shortName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Diagrams " + shortName + ".diagram" + " {\n" + "}";
        return fileContent;
    }

    public static String getInitialDiagramContent(String shortName, String fileName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Diagrams " + fileName + " {\n" + "}";
        return fileContent;
    }

    public static String getInitialServicesContent(String shortName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Rules " + shortName + ".rules" + " {\n" + "}\n\n" + "Services " + shortName + ".services" + " {\n" + "}";
        return fileContent;
    }

    public static String getInitialServicesContent(String shortName, String fileName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "Rules " + fileName.substring(0, fileName.indexOf(".")) + ".rules" + " {\n" + "}\n\n" + "Services " + fileName + " {\n" + "}";
        return fileContent;
    }

    public static String getInitialUIContent(String shortName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "UIDescription " + shortName + " {\n" + "\t\n" + "}";
        return fileContent;
    }

    public static String getInitialUIContent(String shortName, String fileName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "UIDescription " + fileName + " {\n" + "\t\n" + "}";
        return fileContent;
    }

    public static String getInitialActivityExplorerContent(String shortName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "activity-explorer " + shortName + ".activityexplorer" + " {\n\n" + "}";
        return fileContent;
    }

    public static String getInitialActivityExplorerContent(String shortName, String fileName) {
        String fileContent = "/**\n * Copyright (c) PolarSys, " + WizardsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + WizardsUtil.getCurrentUserName() + "\n" + " *\t@date: " + WizardsUtil.getCurrentDate() + "\n" + " *\n" + " */\n" + "activity-explorer " + fileName + " {\n\n" + "}";
        return fileContent;
    }

    public static String getCurrentUserName() {
        return System.getProperty("user.name");
    }

    public static String getCurrentDate() {
        return DateFormat.getDateInstance(3).format(new Date());
    }

    public static String getCurrentYear() {
        return String.valueOf(Calendar.getInstance().get(1));
    }

    public static String[] getSupportedPlatforms() {
        List<String> supportedModelingEnvironment = WizardsUtil.getSupportedModelingEnvironment();
        String[] arrayModelingEnvironment = new String[supportedModelingEnvironment.size() + 1];
        arrayModelingEnvironment[0] = "--";
        int i = 1;
        Iterator<String> iterator = supportedModelingEnvironment.iterator();
        while (iterator.hasNext()) {
            String candidate;
            arrayModelingEnvironment[i] = candidate = iterator.next();
            ++i;
        }
        return arrayModelingEnvironment;
    }

    public static List<String> getSupportedModelingEnvironment() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(GENERATOR_SPECILIZATION_EXTENSION_ID);
        ArrayList<String> targets = new ArrayList<String>();
        if (config.length != 0) {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                if (iConfigurationElement.getName().equals(GENERATOR_SPECILIZATION_EXTENSION_POINT_NAME)) {
                    targets.add(iConfigurationElement.getAttribute(GENERATOR_SPECILIZATION_EXTENSION_POINT_ATTRIBUTE));
                }
                ++n2;
            }
        }
        return targets;
    }

    public static boolean isValid(String name, boolean pojectName) {
        return NamesValidityChecker.isValid((String)name, (boolean)pojectName);
    }
}

