/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.ui.wizard;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.mwe2.language.ui.wizard.Messages;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.xtext.util.StringInputStream;

public class NewMwe2FileWizard
extends BasicNewResourceWizard {
    public static final String WIZARD_ID = "org.eclipse.emf.mwe2.language.ui.wizard.NewMwe2FileWizard";
    private WizardNewFileCreationPage mainPage;
    private static final Logger logger = Logger.getLogger(NewMwe2FileWizard.class);
    @Inject
    @Named(value="file.extensions")
    private String extension;
    @Inject
    private IWorkspace workspace;

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewFileCreationPage("newFilePage1", this.getSelection()){

            protected InputStream getInitialContents() {
                String module = this.getModule();
                if (module != null) {
                    String content = String.format(Messages.NewMwe2FileWizard_initialContent, module);
                    return new StringInputStream(content);
                }
                return new StringInputStream("");
            }

            protected String getModule() {
                IPath path = this.getContainerFullPath();
                IProject project = null;
                IProject[] iProjectArray = NewMwe2FileWizard.this.workspace.getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    if (p.getFullPath().isPrefixOf(path)) {
                        project = p;
                        break;
                    }
                    ++n2;
                }
                IJavaProject javaProject = JavaCore.create(project);
                if (javaProject != null) {
                    try {
                        IPackageFragmentRoot root = null;
                        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
                        int n3 = iPackageFragmentRootArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPackageFragmentRoot candidate = iPackageFragmentRootArray[n4];
                            if (candidate.getPath().isPrefixOf(path)) {
                                root = candidate;
                                break;
                            }
                            ++n4;
                        }
                        if (root != null) {
                            IPath relativePath = path.makeRelativeTo(root.getPath());
                            String pack = relativePath.toString().replace('/', '.');
                            String fileName = this.getFileName();
                            fileName = fileName.substring(0, fileName.indexOf("." + NewMwe2FileWizard.this.extension));
                            String module = String.valueOf(pack) + "." + fileName;
                            return module;
                        }
                    }
                    catch (JavaModelException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                return null;
            }
        };
        this.mainPage.setTitle(Messages.NewMwe2FileWizard_title);
        this.mainPage.setDescription(Messages.NewMwe2FileWizard_description);
        this.mainPage.setFileExtension(this.extension);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(Messages.NewMwe2FileWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/wizban/newfile_wiz.png");
        this.setDefaultPageImageDescriptor(descriptor);
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

