/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.cs.text.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.DefaultGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.MultimapBasedScope;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.polarsys.kitalpha.ad.af.dsl.cs.text.resources.AfdescResourceHelper;
import org.polarsys.kitalpha.ad.af.dsl.cs.text.scoping.AfdescContainer;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class AfdescGlobalScopeProvider
extends DefaultGlobalScopeProvider {
    @Inject
    IResourceDescription.Manager descriptionManager;

    protected IScope getScope(IScope parent, org.eclipse.emf.ecore.resource.Resource context, boolean ignoreCase, EClass type, Predicate<IEObjectDescription> filter) {
        List exportedObjects = Collections.emptyList();
        IScope result = parent;
        ArrayList containers = Lists.newArrayList((Iterable)this.getVisibleContainers(context));
        for (IContainer container : containers) {
            if (!(container instanceof AfdescContainer)) continue;
            result = this.createAedslContainerScope(context, result, container, filter, type, ignoreCase);
        }
        return MultimapBasedScope.createScope((IScope)result, exportedObjects, (boolean)ignoreCase);
    }

    protected IScope createContainerScope(IScope parent, IContainer container, Predicate<IEObjectDescription> filter, EClass type, boolean ignoreCase) {
        return SelectableBasedScope.createScope((IScope)parent, (ISelectable)container, filter, (EClass)type, (boolean)ignoreCase);
    }

    protected IScope createAedslContainerScope(org.eclipse.emf.ecore.resource.Resource eResource, IScope parent, IContainer container, Predicate<IEObjectDescription> filter, EClass type, boolean ignoreCase) {
        Iterable<Object> exportedObjects = Collections.emptyList();
        ResourceSet resourceSet = eResource.getResourceSet();
        List<URI> uris = this.getReferenceableResourceURIs();
        for (URI uri : uris) {
            org.eclipse.emf.ecore.resource.Resource referencedResource = this.loadResource(uri, resourceSet);
            if (referencedResource == null) continue;
            this.addResource(referencedResource, resourceSet);
            IResourceDescription resourceDescription = this.descriptionManager.getResourceDescription(referencedResource);
            exportedObjects = Iterables.concat(exportedObjects, (Iterable)resourceDescription.getExportedObjects());
        }
        return MultimapBasedScope.createScope((IScope)parent, exportedObjects, (boolean)ignoreCase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private org.eclipse.emf.ecore.resource.Resource loadResource(URI uri, ResourceSet resourceSet) {
        try {
            if ("http".equalsIgnoreCase(uri.scheme())) {
                return null;
            }
            if (uri.fragment() != null) {
                EObject result = resourceSet.getEObject(uri, true);
                return result.eResource();
            }
            org.eclipse.emf.ecore.resource.Resource resource = resourceSet.getResource(uri, true);
            if (resource.getContents().isEmpty()) {
                return null;
            }
            return resource;
        }
        catch (RuntimeException ex) {
            if (uri.isPlatformResource()) {
                String platformString = uri.toPlatformString(true);
                URI platformPluginURI = AfdescResourceHelper.URIFix.createPlatformPluginURI(platformString, true);
                return this.loadResource(platformPluginURI, resourceSet);
            }
            return null;
        }
    }

    private org.eclipse.emf.ecore.resource.Resource addResource(org.eclipse.emf.ecore.resource.Resource resource, ResourceSet resourceSet) {
        URI uri = resource.getURI();
        org.eclipse.emf.ecore.resource.Resource r = resourceSet.getResource(uri, false);
        if (r == null) {
            resourceSet.getResources().add((Object)resource);
            return resource;
        }
        return r;
    }

    private List<URI> getReferenceableResourceURIs() {
        Resource[] resources;
        ArrayList<URI> resourceURIs = new ArrayList<URI>();
        Resource[] resourceArray = resources = AfdescResourceHelper.getViewpointResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            URI uri = null;
            uri = r.getProviderLocation().equals((Object)Location.WORSPACE) ? AfdescResourceHelper.URIFix.createPlatformResourceURI(r.getPath(), false) : AfdescResourceHelper.URIFix.createPlatformPluginURI(r.getPath(), false);
            resourceURIs.add(uri);
            ++n2;
        }
        return resourceURIs;
    }
}

