/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.preference.ui;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.kitalpha.doc.gen.business.core.preference.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.preference.internal.Messages;

public class DocgenBrandingPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected static final String[] LOGO_EXTENSIONS = new String[]{"*.png", "*.gif", "*.jpeg", "*.jpg", "*.bmp", "*.*"};
    private final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private StringFieldEditor copyrightField;
    private Group logoGroup;
    private Composite imgPathGroup;
    private BooleanFieldEditor useDefaultLogoValue;
    private FileFieldEditor logoPathField;
    private StringFieldEditor logoAltField;

    public DocgenBrandingPreferencesPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.copyrightField = this.createCopyrightField("DocdenBrandingCopyright", Messages.DOCGEN_BRANDING_COPYRIGHT_FIELD_LABEL, this.getFieldEditorParent());
        this.createLogoWidgets();
        this.addField((FieldEditor)this.copyrightField);
        this.addField((FieldEditor)this.useDefaultLogoValue);
        this.addField((FieldEditor)this.logoPathField);
        this.addField((FieldEditor)this.logoAltField);
    }

    private void createLogoWidgets() {
        this.logoGroup = (Group)this.createParent(this.getFieldEditorParent(), Messages.DOCGEN_BRANDING_LOGO_GROUP_TEXT);
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        Composite composite = new Composite((Composite)this.logoGroup, 0);
        composite.setLayoutData((Object)gd);
        this.useDefaultLogoValue = new BooleanFieldEditor("DocdenBrandingUseDefaultLogo", Messages.DOCGEN_BRANDING_LOGO_USE_DEFAULT_FIELD_LABEL, composite);
        this.imgPathGroup = this.createParent((Composite)this.logoGroup, null);
        this.logoPathField = new FileFieldEditor("DocdenBrandingLogo", Messages.DOCGEN_BRANDING_LOGO_FIELD_LABEL, true, 0, this.imgPathGroup){

            public boolean checkState() {
                return true;
            }
        };
        this.logoPathField.setFileExtensions(LOGO_EXTENSIONS);
        this.logoAltField = this.createCopyrightField("DocdenBrandingLogoALT", Messages.DOCGEN_BRANDING_LOGO_ALT_FIELD_LABEL, (Composite)this.logoGroup);
        this.handleLogoPreferencesDefaultValues();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getPreferenceStore().setDefault("DocdenBrandingCopyright", "Copyright &copy; 2014 The Eclipse Foundation. All Rights Reserved.");
    }

    public void setValid(boolean b) {
        Boolean useDefaultLogo = this.useDefaultLogoValue.getBooleanValue();
        if (useDefaultLogo.booleanValue()) {
            super.setValid(true);
        } else {
            super.setValid(b);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource().equals(this.useDefaultLogoValue)) {
            this.logoPathField.setEnabled(!this.useDefaultLogoValue.getBooleanValue(), this.imgPathGroup);
            this.logoAltField.setEnabled(!this.useDefaultLogoValue.getBooleanValue(), (Composite)this.logoGroup);
            if (this.useDefaultLogoValue.getBooleanValue()) {
                this.logoPathField.loadDefault();
            }
            if (this.useDefaultLogoValue.getBooleanValue()) {
                this.logoAltField.loadDefault();
            }
            this.checkState();
        }
    }

    private Composite createParent(Composite parent, String text) {
        Composite result = null;
        if (text != null && text.trim().length() > 0) {
            result = new Group(parent, 0);
            ((Group)result).setText(text);
        } else {
            result = new Composite(parent, 0);
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        GridLayout layout = new GridLayout();
        result.setLayoutData((Object)gd);
        result.setLayout((Layout)layout);
        return result;
    }

    private StringFieldEditor createCopyrightField(String name, String label, Composite parent) {
        return this.createCopyrightField(name, label, parent, true, null);
    }

    private StringFieldEditor createCopyrightField(String name, String label, Composite parent, boolean allowEmpty, String errorMsg) {
        StringFieldEditor stringField = new StringFieldEditor(name, label, parent);
        stringField.setEmptyStringAllowed(allowEmpty);
        if (!allowEmpty) {
            stringField.setErrorMessage(errorMsg);
        }
        return stringField;
    }

    private void handleLogoPreferencesDefaultValues() {
        Boolean useDefaultLogo = this.store.getBoolean("DocdenBrandingUseDefaultLogo");
        this.logoPathField.setEmptyStringAllowed(useDefaultLogo.booleanValue());
        this.logoPathField.setEnabled(useDefaultLogo == false, this.imgPathGroup);
        if (!useDefaultLogo.booleanValue()) {
            this.store.setDefault("DocdenBrandingLogo", "Default");
        }
        this.logoAltField.setEnabled(useDefaultLogo == false, (Composite)this.logoGroup);
        if (!useDefaultLogo.booleanValue()) {
            this.store.setDefault("DocdenBrandingLogoALT", "[Default logo]");
        }
    }
}

