/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.actions;

import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.OpenActivityExplorerAction;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.ActivityExplorerEditor;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.EObjectLabelProviderHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SessionHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;

public class OpenActivityExplorerAction2
extends OpenActivityExplorerAction {
    private Session session;

    public OpenActivityExplorerAction2(Session session) {
        this.session = session;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public String getText() {
        EObject root = SessionHelper.getRootSemanticModel(this.session);
        return EObjectLabelProviderHelper.getText(root);
    }

    @Override
    public void run() {
        ActivityExplorerEditor current = null;
        Session selectedSession = this.getSession();
        IEditorPart part = ActivityExplorerManager.INSTANCE.getCurrentEditor();
        if (part instanceof ActivityExplorerEditor) {
            current = (ActivityExplorerEditor)part;
        }
        if (selectedSession != null && selectedSession != current.getEditorInput().getSession()) {
            ActivityExplorerEditor editor = current;
            ActivityExplorerEditorInput input = new ActivityExplorerEditorInput(selectedSession, SessionHelper.getRootSemanticModel(selectedSession));
            IEditorSite site = editor.getEditorSite();
            try {
                editor.init(site, input);
                editor.updateEditorPages(editor.getActivePage());
            }
            catch (PartInitException e) {
                ActivityExplorerActivator.getDefault().sentToLogger((Exception)((Object)e));
            }
        }
    }
}

