/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.Messages;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SessionHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenSessionAction
extends BaseSelectionListenerAction {
    private boolean _shouldRunInProgressService = true;
    private List<IFile> _failedOpeningSessions;
    boolean userValue = false;

    public OpenSessionAction() {
        super(Messages.OpenSessionAction_0);
    }

    protected void doOpenSessions() {
        this._failedOpeningSessions = new ArrayList<IFile>();
        for (Object selectedElement : this.getStructuredSelection()) {
            if (!(selectedElement instanceof IFile)) continue;
            IFile file = (IFile)selectedElement;
            try {
                IEditingSession editingSession;
                URI selectedUri;
                Session session;
                if (SessionHelper.getSession(file) != null || (session = SessionManager.INSTANCE.getSession(selectedUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IProgressMonitor)new NullProgressMonitor())) == null) continue;
                if (!session.isOpen()) {
                    session.open((IProgressMonitor)new NullProgressMonitor());
                }
                if (!(editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(session)).isOpen()) {
                    editingSession.open();
                }
                if (!OpenSessionAction.getActivityExplorerPreference()) continue;
                OpenSessionAction.openActivityExplorer(session);
            }
            catch (Exception ex) {
                this._failedOpeningSessions.add(file);
                ActivityExplorerActivator.getDefault().sentToLogger(ex);
            }
        }
    }

    public List<IFile> getFailedOpeningSessions() {
        if (this._failedOpeningSessions == null) {
            this._failedOpeningSessions = Collections.emptyList();
        }
        return this._failedOpeningSessions;
    }

    public void run() {
        if (this.getStructuredSelection().isEmpty()) {
            return;
        }
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    OpenSessionAction.this.doOpenSessions();
                }
            };
            if (this._shouldRunInProgressService) {
                PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            } else {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            ActivityExplorerActivator.getDefault().sentToLogger(ex);
        }
    }

    public static boolean getActivityExplorerPreference() {
        return ActivityExplorerActivator.getDefault().getPreferenceStore().getBoolean("openactivityexplorer");
    }

    public void setRunInProgressService(boolean runInProgressService) {
        this._shouldRunInProgressService = runInProgressService;
    }

    public static boolean openActivityExplorer(final Session session) {
        final boolean[] welcomeOpen = new boolean[1];
        if (session == null) {
            return welcomeOpen[0];
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (activePage != null && session.isOpen()) {
                        activePage.openEditor((IEditorInput)new ActivityExplorerEditorInput(session, SessionHelper.getRootSemanticModel(session)), "org.eclipse.amalgam.explorer.activity.ui.editor.activityExplorerEditor");
                        welcomeOpen[0] = true;
                    }
                }
                catch (PartInitException exception) {
                    StringBuilder loggerMessage = new StringBuilder(".run(..) _ Activity Explorer not Found.");
                    loggerMessage.append(exception.getMessage());
                }
            }
        };
        Display display = Display.getCurrent();
        if (display == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
        return welcomeOpen[0];
    }

    public void setUnAvailableOpenActivityExplorer() {
        this.userValue = OpenSessionAction.getActivityExplorerPreference();
        ActivityExplorerActivator.getDefault().getPreferenceStore().setValue("openactivityexplorer", false);
    }

    public void restoreAvailableOpenActivityExplorer() {
        ActivityExplorerActivator.getDefault().getPreferenceStore().setValue("openactivityexplorer", this.userValue);
    }
}

