/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.Messages;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.CommonActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.DocumentationActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.OverviewActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.extension.point.manager.ActivityExplorerExtensionManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.IVisibility;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ActivityExplorerEditor
extends SharedHeaderFormEditor
implements ITabbedPropertySheetPageContributor,
IPropertyChangeListener {
    public static final String ID = "org.eclipse.amalgam.explorer.activity.ui.editor.activityExplorerEditor";
    private IPartListener _partListener;
    private TabbedPropertySheetPage _propertySheetPage;
    public static final String PROPERTIES_CONTRIBUTOR = "org.eclipse.amalgam.explorer.activity.ui.editor.properties";

    public ActivityExplorerEditor() {
        ActivityExplorerManager.INSTANCE.setEditor(this);
    }

    protected void addPages() {
        try {
            OverviewActivityExplorerPage overViewPage = this.getOrCreateOverviewActivityExplorerPage();
            this.addPage((IFormPage)overViewPage);
            ActivityExplorerManager.INSTANCE.setEditor(this);
            this.createContributedPages();
        }
        catch (PartInitException exception) {
            StringBuilder loggerMessage = new StringBuilder("ActivityExplorerEditor.addPages(..) _ ");
            loggerMessage.append(exception.getMessage());
        }
        this.getContainer().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent cevent) {
            }

            public void controlResized(ControlEvent cevent) {
                IFormPage activePageInstance = ActivityExplorerEditor.this.getActivePageInstance();
                IManagedForm managedForm = activePageInstance.getManagedForm();
                managedForm.reflow(true);
            }
        });
        this.getHeaderForm().dirtyStateChanged();
        ActivityExplorerActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.pages.remove(null);
    }

    public Vector<CommonActivityExplorerPage> getPages() {
        return this.pages;
    }

    public void removeAllPages() {
        int count = super.getPageCount();
        int i = 0;
        while (i < count) {
            this.removePage(0);
            ++i;
        }
    }

    private void createContributedPages() throws PartInitException {
        List<CommonActivityExplorerPage> temp = ActivityExplorerExtensionManager.getAllPages();
        Collections.sort(temp);
        for (CommonActivityExplorerPage page : temp) {
            if (!(page instanceof IVisibility) || page.getPosition() == 0 || !page.isVisible()) continue;
            this.addNewPage((IFormPage)page);
        }
    }

    protected IFormPage createDocumentationPage() {
        return new DocumentationActivityExplorerPage((FormEditor)this);
    }

    protected OverviewActivityExplorerPage getOrCreateOverviewActivityExplorerPage() {
        CommonActivityExplorerPage page;
        List<CommonActivityExplorerPage> contributedPages = ActivityExplorerExtensionManager.getAllPages();
        Collections.sort(contributedPages);
        if (!contributedPages.isEmpty() && (page = contributedPages.get(0)) instanceof OverviewActivityExplorerPage && page.getPosition() == 0) {
            page.initialize((FormEditor)this);
            return (OverviewActivityExplorerPage)page;
        }
        return new OverviewActivityExplorerPage((FormEditor)this);
    }

    public void dispose() {
        if (this._propertySheetPage != null) {
            this._propertySheetPage.dispose();
            this._propertySheetPage = null;
        }
        this.unregisterSession();
        if (this._partListener != null) {
            this.getEditorSite().getPage().removePartListener(this._partListener);
            this._partListener = null;
        }
        ActivityExplorerActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
        if (this.getEditorInput() != null) {
            this.getEditorInput().dispose();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isDirty()) {
            this.getEditorInput().getSession().save((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void doSaveAs() {
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            return this.getOrCreatePropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public ActivityExplorerEditorInput getEditorInput() {
        return (ActivityExplorerEditorInput)super.getEditorInput();
    }

    private IPropertySheetPage getOrCreatePropertySheetPage() {
        if (this._propertySheetPage == null) {
            this._propertySheetPage = new TabbedPropertySheetPage(this){

                public void dispose() {
                    super.dispose();
                    ActivityExplorerEditor.this._propertySheetPage = null;
                }

                public void init(IPageSite pageSite) {
                    super.init(pageSite);
                    pageSite.setSelectionProvider(ActivityExplorerEditor.this.getEditorSite().getSelectionProvider());
                }
            };
        }
        return this._propertySheetPage;
    }

    public String getPartName() {
        return String.valueOf(this.getEditorInput().getName()) + Messages.ActivityExplorerEditor_Title_Suffix;
    }

    public TabbedPropertySheetPage getPropertySheetPage() {
        return this._propertySheetPage;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (((ActivityExplorerEditorInput)input).getRootSemanticElement() == null) {
            throw new PartInitException((IStatus)new Status(2, ActivityExplorerActivator.ID, Messages.ActivityExplorerEditor_1));
        }
        super.init(site, input);
        this._partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (ActivityExplorerEditor.this == part) {
                    IFormPage activePageInstance = ActivityExplorerEditor.this.getActivePageInstance();
                    activePageInstance.setActive(true);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        this.getEditorSite().getPage().addPartListener(this._partListener);
    }

    public boolean isDirty() {
        Session session = this.getEditorInput().getSession();
        if (session != null) {
            return SessionStatus.DIRTY.equals((Object)session.getStatus());
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    private void unregisterSession() {
        Session session;
        ActivityExplorerEditorInput editorInput = this.getEditorInput();
        if (editorInput != null && (session = editorInput.getSession()) != null) {
            Object var2_2 = null;
        }
    }

    public Image getTitleImage() {
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        Image decoratedImage = decorator.decorateImage(super.getTitleImage(), (Object)this.getEditorInput().getSession());
        return decoratedImage;
    }

    protected void setTitleImage(Image titleImage) {
        super.setTitleImage(titleImage);
    }

    private int addNewPage(IFormPage page) {
        int index = 0;
        page.initialize((FormEditor)this);
        try {
            index = this.addPage(page);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return index;
    }

    public IFormPage getPreviousPage(IFormPage current) {
        ListIterator it;
        IFormPage previousPage = null;
        int i = this.pages.indexOf(current);
        if (i > -1 && (it = this.pages.listIterator(i)).hasPrevious()) {
            previousPage = (IFormPage)it.previous();
        }
        return previousPage;
    }

    public IFormPage getNextPage(IFormPage current) {
        ListIterator it;
        IFormPage nextPage = null;
        int i = this.pages.indexOf(current);
        if (i > -1 && (it = this.pages.listIterator(i + 1)).hasNext()) {
            nextPage = (IFormPage)it.next();
        }
        return nextPage;
    }

    public void updateEditorPages(int activatedPage) {
        this.removeAllPages();
        this.addPages();
        this.setActivePage(activatedPage);
        this.setPartName(this.getPartName());
    }

    protected boolean doPropertyChange(PropertyChangeEvent event, boolean value, String property) {
        boolean result = false;
        if (ActivityExplorerExtensionManager.isPage(property)) {
            this.updateEditorPages(0);
            result = true;
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        boolean value = Boolean.valueOf(event.getNewValue().toString());
        if (this.doPropertyChange(event, value, property) && ActivityExplorerManager.INSTANCE.getEditor() != null) {
            ActivityExplorerManager.INSTANCE.getEditor().getActivePageInstance().getManagedForm().reflow(true);
        }
    }
}

