/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.input;

import java.lang.ref.WeakReference;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.OpenSessionAction;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.EObjectLabelProviderHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SessionHelper;
import org.eclipse.amalgam.explorer.activity.ui.internal.ActivityExplorerEditorInputFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class ActivityExplorerEditorInput
implements IEditorInput,
IPersistableElement {
    private static final String FIRST_ANALYSIS_FILE_TAG = "firstAnalysisFile";
    private WeakReference<Session> _sessionReference;
    private WeakReference<EObject> _projectReference;

    ActivityExplorerEditorInput(IMemento memento_p) throws Exception {
        this.loadState(memento_p);
    }

    public ActivityExplorerEditorInput(Session session_p, EObject project_p) {
        this._sessionReference = new WeakReference<Session>(session_p);
        this._projectReference = new WeakReference<EObject>(project_p);
    }

    public void dispose() {
        this._projectReference.clear();
        this._projectReference = null;
        this._sessionReference.clear();
        this._sessionReference = null;
    }

    public boolean equals(Object obj_p) {
        WeakReference<Session> sessionReferenceToCompare;
        Session session;
        boolean result;
        boolean bl = result = this == obj_p;
        if (!result && this._sessionReference != null && obj_p instanceof ActivityExplorerEditorInput && (session = (Session)this._sessionReference.get()) != null && (sessionReferenceToCompare = ((ActivityExplorerEditorInput)obj_p)._sessionReference) != null) {
            result = session.equals(sessionReferenceToCompare.get());
        }
        return result;
    }

    public boolean exists() {
        boolean result = false;
        if (this._sessionReference != null) {
            Session session = (Session)this._sessionReference.get();
            result = session != null && session.isOpen();
        }
        return result;
    }

    public Object getAdapter(Class adapter_p) {
        if (this._sessionReference != null && adapter_p == Session.class) {
            return this._sessionReference.get();
        }
        return null;
    }

    public String getFactoryId() {
        return ActivityExplorerEditorInputFactory.ID;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getModelUiName() {
        EObject project;
        String result = "";
        if (this._projectReference != null && (project = (EObject)this._projectReference.get()) != null) {
            result = EObjectLabelProviderHelper.getText(project);
        }
        return result;
    }

    public EObject getRootSemanticElement() {
        EObject result = null;
        if (this._projectReference != null) {
            result = (EObject)this._projectReference.get();
        }
        return result;
    }

    public String getName() {
        return this.getModelUiName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public Session getSession() {
        return (Session)this.getAdapter(Session.class);
    }

    public String getToolTipText() {
        return this.getName();
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        if (this._sessionReference != null) {
            Session session = (Session)this._sessionReference.get();
            hashCode = session != null ? session.hashCode() : hashCode;
        }
        return hashCode;
    }

    protected void loadState(IMemento memento_p) throws Exception {
        String firstAnalysisFile = memento_p.getString(FIRST_ANALYSIS_FILE_TAG);
        IFile diagramFile = (IFile)ActivityExplorerEditorInput.getPlatformResource((IPath)new Path(firstAnalysisFile));
        Session session = SessionHelper.getSession(diagramFile);
        if (session == null) {
            OpenSessionAction openSessionAction = new OpenSessionAction();
            openSessionAction.setUnAvailableOpenActivityExplorer();
            openSessionAction.setRunInProgressService(false);
            openSessionAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)diagramFile));
            openSessionAction.run();
            session = SessionHelper.getSession(diagramFile);
            openSessionAction.restoreAvailableOpenActivityExplorer();
        }
        this._sessionReference = new WeakReference<Session>(session);
        session = null;
        if (this._sessionReference == null) {
            throw new Exception("Failed to instantiate the session for " + firstAnalysisFile);
        }
        this._projectReference = new WeakReference<EObject>(SessionHelper.getRootSemanticModel((Session)this._sessionReference.get()));
    }

    public void saveState(IMemento memento_p) {
        if (this._sessionReference == null || this._sessionReference.get() == null) {
            return;
        }
        IFile firstAnalysisFile = SessionHelper.getFirstAnalysisFile((DAnalysisSession)this._sessionReference.get());
        if (firstAnalysisFile != null) {
            memento_p.putString(FIRST_ANALYSIS_FILE_TAG, firstAnalysisFile.getFullPath().toString());
        }
    }

    public static ActivityExplorerEditorInput create(IMemento memento_p) {
        ActivityExplorerEditorInput result = null;
        try {
            result = new ActivityExplorerEditorInput(memento_p);
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("Error while trying to restore a ActivityExplorerEditorInput - ");
            loggerMessage.append(exception_p.getMessage());
            ActivityExplorerActivator.getDefault().sentToLogger(loggerMessage.toString(), 4);
        }
        return result;
    }

    public static EObject getRootSemanticElement(Session session_p) {
        EObject result = null;
        for (Resource semanticResource : session_p.getSemanticResources()) {
            EObject object = (EObject)semanticResource.getContents().get(0);
            if (!(object instanceof EObject)) continue;
            result = object;
            break;
        }
        return result;
    }

    private static IResource getPlatformResource(IPath path) {
        if (path == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().findMember(path);
    }
}

