/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PatternFilter
extends ViewerFilter {
    private Map _cache = new HashMap();
    private Map _foundAnyCache = new HashMap();
    private boolean _useCache = false;
    private boolean _includeLeadingWildcard = false;
    private StringMatcher _matcher;
    private boolean _useEarlyReturnIfMatcherIsNull = true;
    private static Object[] EMPTY = new Object[0];

    public final Object[] filter(Viewer viewer_p, Object parent_p, Object[] elements_p) {
        if (this._matcher == null && this._useEarlyReturnIfMatcherIsNull) {
            return elements_p;
        }
        if (!this._useCache) {
            return super.filter(viewer_p, parent_p, elements_p);
        }
        Object[] filtered = (Object[])this._cache.get(parent_p);
        if (filtered == null) {
            Boolean foundAny = (Boolean)this._foundAnyCache.get(parent_p);
            filtered = foundAny != null && foundAny == false ? EMPTY : super.filter(viewer_p, parent_p, elements_p);
            this._cache.put(parent_p, filtered);
        }
        return filtered;
    }

    protected boolean isAnyVisible(Viewer viewer_p, Object parent_p, Object[] elements_p) {
        if (this._matcher == null) {
            return true;
        }
        if (!this._useCache) {
            return this.computeAnyVisible(viewer_p, parent_p, elements_p);
        }
        Object[] filtered = (Object[])this._cache.get(parent_p);
        if (filtered != null) {
            return filtered.length > 0;
        }
        Boolean foundAny = (Boolean)this._foundAnyCache.get(parent_p);
        if (foundAny == null) {
            foundAny = this.computeAnyVisible(viewer_p, parent_p, elements_p) ? Boolean.TRUE : Boolean.FALSE;
            this._foundAnyCache.put(parent_p, foundAny);
        }
        return foundAny;
    }

    private boolean computeAnyVisible(Viewer viewer_p, Object parentElement_p, Object[] elements_p) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements_p.length && !elementFound) {
            Object element = elements_p[i];
            elementFound = this.isElementVisible(viewer_p, parentElement_p, element);
            ++i;
        }
        return elementFound;
    }

    public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
        return this.isElementVisible(viewer_p, parentElement_p, element_p);
    }

    public final void setIncludeLeadingWildcard(boolean includeLeadingWildcard_p) {
        this._includeLeadingWildcard = includeLeadingWildcard_p;
    }

    public void setPattern(String patternString_p) {
        if ("org.eclipse.ui.keys.optimization.true".equals(patternString_p)) {
            this._useEarlyReturnIfMatcherIsNull = true;
            return;
        }
        if ("org.eclipse.ui.keys.optimization.false".equals(patternString_p)) {
            this._useEarlyReturnIfMatcherIsNull = false;
            return;
        }
        this.clearCaches();
        if (patternString_p == null || patternString_p.equals("")) {
            this._matcher = null;
        } else {
            String pattern = String.valueOf(patternString_p) + "*";
            if (this._includeLeadingWildcard) {
                pattern = "*" + pattern;
            }
            this._matcher = new StringMatcher(pattern, true, false);
        }
    }

    public void clearCaches() {
        this._cache.clear();
        this._foundAnyCache.clear();
    }

    private boolean match(String string_p) {
        if (this._matcher == null) {
            return true;
        }
        return this._matcher.match(string_p);
    }

    public boolean isElementSelectable(Object element_p) {
        return element_p != null;
    }

    public boolean isElementVisible(Viewer viewer_p, Object parentElement_p, Object element_p) {
        return this.isParentMatch(viewer_p, parentElement_p, element_p) || this.isLeafMatch(viewer_p, parentElement_p, element_p);
    }

    protected boolean isParentMatch(Viewer viewer_p, Object parentElement_p, Object element_p) {
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer_p).getContentProvider()).getChildren(element_p);
        if (children != null && children.length > 0) {
            return this.isAnyVisible(viewer_p, element_p, children);
        }
        return false;
    }

    protected boolean isLeafMatch(Viewer viewer_p, Object parentElement_p, Object element_p) {
        String labelText = ((ILabelProvider)((StructuredViewer)viewer_p).getLabelProvider()).getText(element_p);
        if (labelText == null) {
            return false;
        }
        return this.wordMatches(labelText);
    }

    protected boolean isLeafAlreadyFilteredOutByOtherFilters(StructuredViewer viewer_p, Object parent_p, Object element_p) {
        ViewerFilter[] filters;
        ViewerFilter[] viewerFilterArray = filters = viewer_p.getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter != this && !filter.select((Viewer)viewer_p, parent_p, element_p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String[] getWords(String text_p) {
        ArrayList<String> words = new ArrayList<String>();
        BreakIterator iter = BreakIterator.getWordInstance();
        iter.setText(text_p);
        int i = iter.first();
        while (i != -1 && i < text_p.length()) {
            int j = iter.following(i);
            if (j == -1) {
                j = text_p.length();
            }
            if (Character.isLetterOrDigit(text_p.charAt(i))) {
                String word = text_p.substring(i, j);
                words.add(word);
            }
            i = j;
        }
        return words.toArray(new String[words.size()]);
    }

    protected boolean wordMatches(String text_p) {
        if (text_p == null) {
            return false;
        }
        if (this.match(text_p)) {
            return true;
        }
        String[] words = this.getWords(text_p);
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (this.match(word)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setUseCache(boolean useCache_p) {
        this._useCache = useCache_p;
    }
}

