/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.extension.point.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.CommonActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.predicates.IPredicate;
import org.eclipse.amalgam.explorer.activity.ui.internal.extension.point.manager.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.osgi.framework.Bundle;

public class ActivityExplorerExtensionManager {
    public static final String PROVIDER_PAGES_EXT = "org.eclipse.amalgam.explorer.activity.ui.pagesProvider";
    public static final String PROVIDER_SECTIONS_EXT = "org.eclipse.amalgam.explorer.activity.ui.sectionsProvider";
    public static final String PROVIDER_ACTIVITIES_EXT = "org.eclipse.amalgam.explorer.activity.ui.activitiesProvider";
    public static final String PAGE = "Page";
    public static final String ATT_CLASS = "class";
    public static final String ATT_TAB_NAME = "tabName";
    public static final String ATT_TITLE = "title";
    public static final String ATT_IMAGE = "image";
    public static final String ATT_IMAGE_OFF = "imageOff";
    public static final String ATT_IMAGE_ON = "imageOn";
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String DESCRIPTION = "Description";
    public static final String ATT_INDEX = "index";
    public static final String ATT_VIEWER = "viewer";
    public static final String OVERVIEW = "Overview";
    public static final String ATT_OVERVIEW_IMG_ON = "imageOn";
    public static final String ATT_OVERVIEW_IMG_OFF = "imageOff";
    public static final String SECTION = "Section";
    public static final String ATT_EXPANDED = "expanded";
    public static final String ATT_FILTERING = "filtering";
    public static final String ACTIVITY = "Activity";
    public static final String ATT_DIAGRAM_REPRESENTATION = "diagram";
    public static final String ATT_VIEWPOINT = "viewpoint";
    public static final String ATT_SECTION_PAGE_ID = "pageId";
    public static final String ATT_ACTIVITY_SECTION_ID = "sectionId";
    public static final String PREDICATE = "Predicate";

    public static IConfigurationElement[] getAllProviderExtensions() {
        return ActivityExplorerExtensionManager.getExtensionElt(PROVIDER_PAGES_EXT);
    }

    private static IConfigurationElement[] getExtensionElt(String id) {
        IExtensionPoint point = ActivityExplorerExtensionManager.getExtensionPoint(id);
        IExtension[] extensions = point.getExtensions();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            configElements.addAll(Arrays.asList(extension.getConfigurationElements()));
            ++n2;
        }
        return configElements.toArray(new IConfigurationElement[0]);
    }

    public static IExtensionPoint getExtensionPoint(String id) {
        return Platform.getExtensionRegistry().getExtensionPoint(id);
    }

    private static CommonActivityExplorerPage getPage(IConfigurationElement element) throws CoreException {
        CommonActivityExplorerPage page = null;
        if (element != null) {
            CommonActivityExplorerPage.setID(ActivityExplorerExtensionManager.getId(element));
            if (element.getAttribute(ATT_CLASS) != null) {
                page = (CommonActivityExplorerPage)element.createExecutableExtension(ATT_CLASS);
            } else {
                page = new CommonActivityExplorerPage();
                page.setInitializationData(element, ATT_CLASS, null);
            }
        }
        return page;
    }

    public static List<CommonActivityExplorerPage> getAllPages() {
        ArrayList<CommonActivityExplorerPage> providers = new ArrayList<CommonActivityExplorerPage>();
        List<IConfigurationElement> extensions = Arrays.asList(ActivityExplorerExtensionManager.getExtensionElt(PROVIDER_PAGES_EXT));
        for (IConfigurationElement extension : extensions) {
            try {
                providers.add(ActivityExplorerExtensionManager.getPage(extension));
            }
            catch (CoreException e) {
                ActivityExplorerActivator.getDefault().getLog().log((IStatus)new Status(4, ActivityExplorerActivator.ID, Messages.ActivityExplorerExtensionManager_0, (Throwable)e));
            }
        }
        return providers;
    }

    public static List<IConfigurationElement> getAllPagesElt() {
        List<IConfigurationElement> extensions = Arrays.asList(ActivityExplorerExtensionManager.getExtensionElt(PROVIDER_PAGES_EXT));
        return extensions;
    }

    public static List<IConfigurationElement> getAllSectionsExtensions() {
        List<IConfigurationElement> extensions = Arrays.asList(ActivityExplorerExtensionManager.getExtensionElt(PROVIDER_SECTIONS_EXT));
        return extensions;
    }

    public static List<IConfigurationElement> getAllSectionsExtensionForPageId(String id) {
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement elt : ActivityExplorerExtensionManager.getAllSectionsExtensions()) {
            if (!ActivityExplorerExtensionManager.getPageId(elt).equals(id)) continue;
            list.add(elt);
        }
        return list;
    }

    public static List<IConfigurationElement> getAllActivitiesExtensionForSectionId(String id) {
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement elt : ActivityExplorerExtensionManager.getAllActivitiesExtensions()) {
            if (!ActivityExplorerExtensionManager.getSectionId(elt).equals(id)) continue;
            list.add(elt);
        }
        return list;
    }

    public static List<IConfigurationElement> getAllActivitiesExtensions() {
        List<IConfigurationElement> extensions = Arrays.asList(ActivityExplorerExtensionManager.getExtensionElt(PROVIDER_ACTIVITIES_EXT));
        return extensions;
    }

    public static CommonActivityExplorerPage getPageById(String id) {
        CommonActivityExplorerPage result = null;
        for (IConfigurationElement page : Arrays.asList(ActivityExplorerExtensionManager.getExtensionElt(PROVIDER_PAGES_EXT))) {
            if (!ActivityExplorerExtensionManager.getId(page).equals(id)) continue;
            try {
                result = ActivityExplorerExtensionManager.getPage(page);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String getPageId(IConfigurationElement element) {
        return element.getAttribute(ATT_SECTION_PAGE_ID);
    }

    public static String getSectionId(IConfigurationElement element) {
        return element.getAttribute(ATT_ACTIVITY_SECTION_ID);
    }

    public static List<IConfigurationElement> getSectionsFromPageId(String id) {
        ArrayList<IConfigurationElement> sections = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement page : Arrays.asList(ActivityExplorerExtensionManager.getExtensionElt(PROVIDER_PAGES_EXT))) {
            if (!ActivityExplorerExtensionManager.getId(page).equals(id)) continue;
            sections.addAll(ActivityExplorerExtensionManager.getSections(page));
        }
        return sections;
    }

    public static List<IConfigurationElement> getActivitiesFromPageId(String id) {
        ArrayList<IConfigurationElement> sections = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement page : Arrays.asList(ActivityExplorerExtensionManager.getExtensionElt(PROVIDER_PAGES_EXT))) {
            if (!ActivityExplorerExtensionManager.getId(page).equals(id)) continue;
            sections.addAll(ActivityExplorerExtensionManager.getSections(page));
        }
        return sections;
    }

    public static String getId(IConfigurationElement element) {
        return element.getAttribute(ATT_ID);
    }

    public static String getName(IConfigurationElement element) {
        String name;
        String att = ATT_NAME;
        if (element.getName().equals(PAGE)) {
            att = ATT_TITLE;
        }
        return (name = element.getAttribute(att)) == null ? "no-name" : name;
    }

    public static String getTitle(IConfigurationElement element) {
        String title = element.getAttribute(ATT_TITLE);
        return title == null ? "no-title" : title;
    }

    public static String getTabName(IConfigurationElement element) {
        return element.getAttribute(ATT_TAB_NAME);
    }

    public static String getIndex(IConfigurationElement element) {
        return element.getAttribute(ATT_INDEX);
    }

    public static Image getImage(IConfigurationElement element) {
        Image image = null;
        String img = element.getAttribute(ATT_IMAGE);
        if (img != null) {
            String pluginId = ActivityExplorerExtensionManager.getPluginId(element);
            image = ActivityExplorerActivator.getDefault().getImage(pluginId, img);
        }
        return image;
    }

    public static Image getImageOff(IConfigurationElement element) {
        Image image = null;
        String img = element.getAttribute("imageOff");
        if (img != null) {
            String pluginId = ActivityExplorerExtensionManager.getPluginId(element);
            image = ActivityExplorerActivator.getDefault().getImage(pluginId, img);
        }
        return image;
    }

    public static Image getImageOn(IConfigurationElement element) {
        Image image = null;
        String img = element.getAttribute("imageOn");
        if (img != null) {
            String pluginId = ActivityExplorerExtensionManager.getPluginId(element);
            image = ActivityExplorerActivator.getDefault().getImage(pluginId, img);
        }
        return image;
    }

    public static boolean getIsDisplayViewerInPage(IConfigurationElement element) {
        String bool = element.getAttribute(ATT_VIEWER);
        return Boolean.parseBoolean(bool);
    }

    public static IConfigurationElement getOverviewElement(IConfigurationElement element) {
        return ActivityExplorerExtensionManager.getChild(element, OVERVIEW);
    }

    private static IConfigurationElement getChild(IConfigurationElement element, String name) {
        IConfigurationElement child = null;
        IConfigurationElement[] children = element.getChildren(name);
        if (children.length > 0) {
            child = children[0];
        }
        return child;
    }

    public static String getOverviewImageOn(IConfigurationElement element) {
        IConfigurationElement overview = ActivityExplorerExtensionManager.getOverviewElement(element);
        String img = overview.getAttribute("imageOn");
        return img == null ? "icons/full/overview/logo_on.png" : img;
    }

    public static String getOverviewImageOff(IConfigurationElement element) {
        IConfigurationElement overview = ActivityExplorerExtensionManager.getOverviewElement(element);
        String img = overview.getAttribute("imageOff");
        return img == null ? "icons/full/overview/logo_off.png" : img;
    }

    public static String getOverviewDescription(IConfigurationElement element) {
        IConfigurationElement overview = ActivityExplorerExtensionManager.getOverviewElement(element);
        return ActivityExplorerExtensionManager.getDescription(overview);
    }

    public static String getDescription(IConfigurationElement element) {
        IConfigurationElement desc;
        String description = null;
        if (element != null && (desc = ActivityExplorerExtensionManager.getChild(element, DESCRIPTION)) != null) {
            description = desc.getValue();
        }
        return description;
    }

    public static List<IConfigurationElement> getSections(IConfigurationElement element) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        String id = ActivityExplorerExtensionManager.getId(element);
        result.addAll(Arrays.asList(element.getChildren(SECTION)));
        result.addAll(ActivityExplorerExtensionManager.getAllSectionsExtensionForPageId(id));
        return result;
    }

    public static String getPluginId(IConfigurationElement element) {
        IContributor contributor = element.getContributor();
        Bundle bundle = Platform.getBundle((String)contributor.getName());
        String id = bundle.getSymbolicName();
        return id;
    }

    public static boolean getIsExpanded(IConfigurationElement element) {
        String bool = element.getAttribute(ATT_EXPANDED);
        boolean result = Boolean.parseBoolean(bool);
        return result;
    }

    public static boolean getIsFiltering(IConfigurationElement element) {
        String bool = element.getAttribute(ATT_FILTERING);
        boolean result = Boolean.parseBoolean(bool);
        return result;
    }

    public static List<IConfigurationElement> getActivities(IConfigurationElement element) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        String id = ActivityExplorerExtensionManager.getId(element);
        result.addAll(Arrays.asList(element.getChildren(ACTIVITY)));
        result.addAll(ActivityExplorerExtensionManager.getAllActivitiesExtensionForSectionId(id));
        return result;
    }

    public static IHyperlinkListener getActivityAdapter(IConfigurationElement element) {
        IHyperlinkListener listener = null;
        String type = element.getName();
        String id = ActivityExplorerExtensionManager.getId(element);
        try {
            String c = element.getAttribute(ATT_CLASS);
            if (c != null) {
                listener = (IHyperlinkListener)element.createExecutableExtension(ATT_CLASS);
            }
        }
        catch (CoreException e) {
            Status error = new Status(4, ActivityExplorerActivator.ID, String.valueOf(Messages.ActivityExplorerExtensionManager_1) + type + Messages.ActivityExplorerExtensionManager_2 + id + Messages.ActivityExplorerExtensionManager_3, (Throwable)e);
            ActivityExplorerActivator.getDefault().getLog().log((IStatus)error);
        }
        return listener;
    }

    public static IPredicate getPredicate(IConfigurationElement elem) {
        IPredicate predicate = null;
        IConfigurationElement element = ActivityExplorerExtensionManager.getChild(elem, PREDICATE);
        if (element != null) {
            String type = element.getName();
            try {
                String c = elem.getAttribute(ATT_CLASS);
                if (c != null) {
                    predicate = (IPredicate)element.createExecutableExtension(ATT_CLASS);
                }
            }
            catch (CoreException e) {
                Status error = new Status(4, ActivityExplorerActivator.ID, String.valueOf(Messages.ActivityExplorerExtensionManager_1) + type + Messages.ActivityExplorerExtensionManager_2 + Messages.ActivityExplorerExtensionManager_3, (Throwable)e);
                ActivityExplorerActivator.getDefault().getLog().log((IStatus)error);
            }
        }
        return predicate;
    }

    public static boolean isPage(String id) {
        return ActivityExplorerExtensionManager.getPageById(id) != null;
    }

    public static boolean isSection(String pageId, String sectionId) {
        boolean result = false;
        for (IConfigurationElement element : ActivityExplorerExtensionManager.getSectionsFromPageId(pageId)) {
            result |= ActivityExplorerExtensionManager.getId(element).equals(sectionId);
        }
        return result;
    }

    public static boolean isActivity(String pageId, String sectionId, String activityId) {
        boolean result = false;
        for (IConfigurationElement element : ActivityExplorerExtensionManager.getSectionsFromPageId(pageId)) {
            if (!ActivityExplorerExtensionManager.getId(element).equals(sectionId)) continue;
            for (IConfigurationElement element2 : ActivityExplorerExtensionManager.getActivities(element)) {
                result |= ActivityExplorerExtensionManager.getId(element2).equals(activityId);
            }
        }
        return result;
    }
}

