/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.session.listeners;

import java.lang.ref.WeakReference;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.ActivityExplorerEditor;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SessionHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;

public class ActivityExplorerSessionListener
implements SessionManagerListener {
    protected void run(Runnable runnable) {
        if (runnable != null) {
            Display display = Display.getCurrent();
            if (display == null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
            } else {
                runnable.run();
            }
        }
    }

    public void notify(Session sessionp, int notification) {
        WeakReference<Session> session = new WeakReference<Session>(sessionp);
        Runnable runnable = null;
        switch (notification) {
            case 8: {
                this.notifyClosingSession(session);
                break;
            }
            case 0: {
                this.update(session);
                break;
            }
            case 10: {
                this.notifyRepresentationChange(session);
                break;
            }
            case 7: {
                this.notifyOpenedSession(session);
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                this.notifySemanticChange(session);
                break;
            }
            case 5: {
                this.notifyReplacedSession(session);
            }
        }
        this.run(runnable);
    }

    protected void notifyReplacedSession(WeakReference<Session> session) {
        this.notifyRepresentationChange(session);
    }

    protected void notifySemanticChange(final WeakReference<Session> session2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Session currentSession = (Session)session2.get();
                if (currentSession != null) {
                    ActivityExplorerEditor editor = ActivityExplorerManager.INSTANCE.getEditorFromSession(currentSession);
                    if (editor == null) {
                        return;
                    }
                    if (editor.getEditorInput() == null) {
                        return;
                    }
                    if (!currentSession.equals(editor.getEditorInput().getSession())) {
                        return;
                    }
                    IManagedForm headerForm = editor.getHeaderForm();
                    if (headerForm != null) {
                        headerForm.dirtyStateChanged();
                    }
                }
            }
        };
        this.run(runnable);
    }

    protected void notifyOpenedSession(final WeakReference<Session> session2) {
        if (session2.get() != null && !((Session)session2.get()).getSemanticResources().isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage activePage;
                        boolean open = ActivityExplorerActivator.getDefault().getPreferenceStore().getBoolean("openactivityexplorer");
                        if (open && (activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                            activePage.openEditor((IEditorInput)new ActivityExplorerEditorInput((Session)session2.get(), SessionHelper.getRootSemanticModel((Session)session2.get())), "org.eclipse.amalgam.explorer.activity.ui.editor.activityExplorerEditor");
                        }
                    }
                    catch (Exception exception) {
                        StringBuilder loggerMessage = new StringBuilder(".run(..) _ ActivityExplorer not Found.");
                        loggerMessage.append(exception.getMessage());
                        ActivityExplorerActivator.getDefault().sentToLogger(loggerMessage.toString(), 4);
                    }
                }
            };
            this.run(runnable);
        }
    }

    protected void notifyRepresentationChange(final WeakReference<Session> session2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IManagedForm headerForm;
                ActivityExplorerEditor editor;
                Session currentSession = (Session)session2.get();
                if (currentSession != null && (editor = ActivityExplorerManager.INSTANCE.getEditorFromSession(currentSession)) != null && (headerForm = editor.getHeaderForm()) != null) {
                    headerForm.dirtyStateChanged();
                }
            }
        };
        this.run(runnable);
    }

    protected void notifyClosingSession(final WeakReference<Session> session2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ActivityExplorerEditor editor;
                Session currentSession = (Session)session2.get();
                if (currentSession != null && (editor = ActivityExplorerManager.INSTANCE.getEditorFromSession(currentSession)) != null) {
                    editor.close(false);
                }
            }
        };
        this.run(runnable);
    }

    protected void update(final WeakReference<Session> session) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ActivityExplorerEditor editor;
                Session currentSession = (Session)session.get();
                if (currentSession != null && currentSession.isOpen() && (editor = ActivityExplorerManager.INSTANCE.getEditorFromSession(currentSession)) != null) {
                    editor.updateEditorPages(0);
                }
            }
        };
        this.run(runnable);
    }

    public void notifyAddSession(Session newSession) {
    }

    public void notifyRemoveSession(Session removedSession) {
    }

    public void notifyUpdatedSession(Session updatedSession) {
        this.notify(updatedSession, 10);
    }

    public void viewpointSelected(Viewpoint selectedViewpoint) {
    }

    public void viewpointDeselected(Viewpoint deselectedViewpoint) {
    }
}

