/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.StringHelper;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class CloneDiagramCommand
extends AbstractCommand {
    private Collection<DRepresentation> _representations;
    private Collection<DRepresentation> _clones;
    private Collection<ICloneListener> _listeners;

    public CloneDiagramCommand(Collection<DRepresentation> representations_p) {
        super(Messages.CloneDiagramCommand_0);
        this._representations = representations_p;
    }

    public void dispose() {
        super.dispose();
        if (this._clones != null) {
            this._clones.clear();
            this._clones = null;
        }
        if (this._listeners != null) {
            this._listeners.clear();
            this._listeners = null;
        }
        if (this._representations != null) {
            this._representations = null;
        }
    }

    public void addCloneListener(ICloneListener listener_p) {
        if (listener_p == null) {
            return;
        }
        if (this._listeners == null) {
            this._listeners = new HashSet<ICloneListener>(1);
        }
        this._listeners.add(listener_p);
    }

    public void removeCloneListener(ICloneListener listener_p) {
        if (this._listeners == null || listener_p == null) {
            return;
        }
        this._listeners.remove(listener_p);
    }

    protected void notifyListeners(EventType type_p, DRepresentation clone_p, Session session_p) {
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        ArrayList<ICloneListener> listeners = new ArrayList<ICloneListener>(this._listeners);
        for (ICloneListener listener : listeners) {
            try {
                if (EventType.ADD.equals((Object)type_p)) {
                    listener.cloneCreated(clone_p, session_p);
                    continue;
                }
                if (!EventType.REMOVE.equals((Object)type_p)) continue;
                listener.cloneAboutToBeRemoved(clone_p, session_p);
            }
            catch (Exception exception) {
                ActivityExplorerActivator.getDefault().sentToLogger("Unable to notify listeners !", 4);
            }
        }
    }

    public boolean canUndo() {
        return this._clones != null && this._clones.size() > 0;
    }

    public void execute() {
        if (this._clones == null) {
            this._clones = new ArrayList<DRepresentation>(0);
        } else if (this._clones.size() > 0) {
            this._clones.clear();
        }
        for (DRepresentation representation : this._representations) {
            if (representation instanceof DSemanticDecorator) {
                EObject target = ((DSemanticDecorator)representation).getTarget();
                Session session = SessionManager.INSTANCE.getSession(target);
                DRepresentation copyRepresentation = DialectManager.INSTANCE.copyRepresentation(representation, this.getCloneName(representation, session), session, null);
                this._clones.add(copyRepresentation);
                continue;
            }
            ActivityExplorerActivator.getDefault().getLog().log((IStatus)new Status(2, ActivityExplorerActivator.ID, "Clone is not supported for " + representation.getName()));
        }
    }

    protected String getCloneName(DRepresentation representation_p, Session session_p) {
        String message = "GET_NAME_PREFIX ";
        String cloneName = StringHelper.formatMessage(message, new Object[]{"", representation_p.getName()});
        boolean cloneNameFound = false;
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(session_p);
        int i = 1;
        while (!cloneNameFound) {
            boolean collision = false;
            for (DRepresentation representation : allRepresentations) {
                if (!cloneName.equals(representation.getName())) continue;
                collision = true;
                break;
            }
            if (collision) {
                cloneName = StringHelper.formatMessage(message, new Object[]{"" + ++i + ' ', representation_p.getName()});
            }
            boolean bl = cloneNameFound = !collision;
        }
        return cloneName;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        for (DRepresentation representation : this._clones) {
            Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)representation).getTarget());
            DialectManager.INSTANCE.deleteRepresentation(representation, session);
        }
        this._clones.clear();
    }

    protected static enum EventType {
        ADD,
        REMOVE;

    }

    public static interface ICloneListener {
        public void cloneCreated(DRepresentation var1, Session var2);

        public void cloneAboutToBeRemoved(DRepresentation var1, Session var2);
    }
}

