/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MoveRepresentationAction
extends BaseSelectionListenerAction {
    public static final String MOVE_DIAGRAMS_MENU_ID = "MoveDiagrams.Menu.ID";
    private ArrayList<DRepresentation> _representationsToMove;
    private Session _session;
    private Collection<Resource> _availableTargetResources;

    public MoveRepresentationAction() {
        super("");
    }

    public void run(IAction action_p) {
    }

    public void dispose() {
        if (this._representationsToMove != null) {
            this._representationsToMove.clear();
        }
        if (this._availableTargetResources != null) {
            this._availableTargetResources.clear();
        }
        this._session = null;
    }

    public boolean updateSelection(IStructuredSelection selection_p) {
        if (selection_p.isEmpty()) {
            return false;
        }
        boolean enabled = true;
        this._representationsToMove = new ArrayList(0);
        this._session = null;
        Iterator iterator = selection_p.toList().iterator();
        while (iterator.hasNext() && enabled) {
            Object element = iterator.next();
            if (element instanceof DRepresentation) {
                this._representationsToMove.add((DRepresentation)element);
                if (this._session != null) {
                    enabled = SessionManager.INSTANCE.getSession(((DSemanticDecorator)element).getTarget()).equals(this._session);
                    continue;
                }
                this._session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)element).getTarget());
                enabled = this._session != null;
                continue;
            }
            enabled = false;
            break;
        }
        if (enabled) {
            this._availableTargetResources = new ArrayList<Resource>(((DAnalysisSession)this._session).getAllSessionResources());
            Collection<Resource> representationResources = this.collectRepresentationResources(this._representationsToMove);
            this._availableTargetResources.removeAll(representationResources);
            enabled = !this._availableTargetResources.isEmpty();
        }
        return enabled;
    }

    private Collection<Resource> collectRepresentationResources(Collection<DRepresentation> movableRepresentations_p) {
        HashSet<Resource> result = new HashSet<Resource>();
        for (DRepresentation representation : movableRepresentations_p) {
            result.add(representation.eResource());
        }
        return result;
    }

    public Collection<IAction> getMoveActions() {
        ArrayList<IAction> actions = new ArrayList<IAction>(0);
        for (Resource availableTargetResource : this._availableTargetResources) {
            Collection availableDAnalysys = EcoreUtil.getObjectsByType((Collection)availableTargetResource.getContents(), (EClassifier)ViewpointPackage.eINSTANCE.getDAnalysis());
            for (DAnalysis dAnalysis : availableDAnalysys) {
                actions.add((IAction)this.createMoveRepresentationsActions((DAnalysisSession)this._session, this._representationsToMove, dAnalysis));
            }
        }
        return actions;
    }

    private Action createMoveRepresentationsActions(final DAnalysisSession session, final Collection<DRepresentation> movableRepresentations, final DAnalysis targetAnalysis) {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/forward.gif");
        return new Action(String.valueOf(Messages.MoveRepresentationAction_1) + targetAnalysis.eResource().getURI(), descriptor){

            public void run() {
                session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                    public void doExecute() {
                        IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession((Session)session);
                        if (uiSession != null) {
                            for (DRepresentation representation : movableRepresentations) {
                                this.closeOpenedEditor(uiSession, representation);
                            }
                        }
                        for (DRepresentation representation : movableRepresentations) {
                            session.moveRepresentation(targetAnalysis, representation);
                        }
                    }

                    private void closeOpenedEditor(IEditingSession uiSession, DRepresentation representation) {
                        DialectEditor editor = uiSession.getEditor(representation);
                        if (editor != null) {
                            editor.getEditorSite().getPage().closeEditor((IEditorPart)editor, false);
                        }
                    }
                });
            }
        };
    }

    public IMenuManager fillContextMenu(IStructuredSelection structuredSelection_p) {
        MenuManager subMenuManager = new MenuManager(Messages.MoveRepresentationAction_2);
        this.updateSelection(structuredSelection_p);
        if (this.isEnabled()) {
            for (IAction containedAction : this.getMoveActions()) {
                this.addAction((IMenuManager)subMenuManager, null, containedAction);
            }
        }
        return subMenuManager;
    }

    protected void addAction(IMenuManager menu_p, String groupId_p, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action){

            public boolean isDirty() {
                return true;
            }

            public boolean isDynamic() {
                return true;
            }
        };
        if (groupId_p != null) {
            menu_p.appendToGroup(groupId_p, (IContributionItem)item);
        } else {
            menu_p.add((IContributionItem)item);
        }
    }
}

