/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.EditionTableDescription;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NewRepresentationAction
extends BaseSelectionListenerAction {
    private EObject _selectedEObject;
    protected RepresentationDescription _description;
    protected Session _session;
    protected boolean _forceDefaultName;
    protected boolean _openRepresentation;

    public NewRepresentationAction(RepresentationDescription description_p, EObject selectedEObject_p, Session session_p) {
        this(description_p, selectedEObject_p, session_p, false, true);
    }

    public NewRepresentationAction(RepresentationDescription description_p, EObject selectedEObject_p, Session session_p, boolean forceDefaultName_p, boolean openRepresentation_p) {
        super(description_p.getName());
        String label = description_p.getLabel();
        if (label != null && label.length() > 1) {
            this.setText(label);
        }
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = description_p instanceof CrossTableDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.table.ui", (String)"/icons/full/obj16/CrossTableDescription.gif") : (description_p instanceof EditionTableDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.table.ui", (String)"/icons/full/obj16/DTable.gif") : AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/obj16/DAnalysis.gif"));
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        this.setImageDescriptor(imageDescriptor);
        this._selectedEObject = selectedEObject_p;
        this._description = description_p;
        this._session = session_p;
        this._forceDefaultName = forceDefaultName_p;
        this._openRepresentation = openRepresentation_p;
    }

    public void run() {
        String defaultName = this.computeDefaultName(this._selectedEObject, this._description);
        if (!this._forceDefaultName) {
            String dialogTitle = "Type representation name";
            Shell activeShell = Display.getDefault().getActiveShell();
            InputDialog representationNameDlg = new InputDialog(activeShell, dialogTitle, dialogTitle, defaultName, null);
            if (representationNameDlg.open() == 0) {
                defaultName = representationNameDlg.getValue();
            } else {
                throw new OperationCanceledException();
            }
        }
        NewRepresentationCommand command = new NewRepresentationCommand(defaultName, this._selectedEObject, this._description, this._session);
        TransactionUtil.getEditingDomain((EObject)this._selectedEObject).getCommandStack().execute((Command)command);
        if (command.getRepresentation() != null) {
            SessionManager.INSTANCE.notifyRepresentationCreated(this._session);
            if (this._openRepresentation) {
                DialectUIManager.INSTANCE.openEditor(this._session, command.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected String computeDefaultName(EObject eObject_p, RepresentationDescription repDescription_p) {
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)eObject_p);
        String newName = "New ";
        newName = !StringUtil.isEmpty((String)repDescription_p.getLabel()) ? String.valueOf(newName) + repDescription_p.getLabel() : String.valueOf(newName) + repDescription_p.getName();
        String titleExpression = repDescription_p.getTitleExpression();
        if (!StringUtil.isEmpty((String)titleExpression)) {
            try {
                newName = interpreter.evaluateString(eObject_p, titleExpression);
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
            }
        }
        return newName;
    }

    private class NewRepresentationCommand
    extends RecordingCommand {
        private String _newName;
        private DRepresentation _representation;
        private EObject _eObject;
        private RepresentationDescription _repDescription;
        private Session _currentSession;

        public NewRepresentationCommand(String newName_p, EObject eObject_p, RepresentationDescription repDescription_p, Session session_p) {
            super(TransactionUtil.getEditingDomain((EObject)eObject_p));
            this._newName = newName_p;
            this._eObject = eObject_p;
            this._repDescription = repDescription_p;
            this._currentSession = session_p;
        }

        public void commandInterrupted() {
            this.commandRolledBack();
        }

        public void commandRolledBack() {
            this._representation = null;
        }

        public DRepresentation getRepresentation() {
            return this._representation;
        }

        public void doExecute() {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this._representation = DialectManager.INSTANCE.createRepresentation(this._newName, this._eObject, this._repDescription, this._currentSession, (IProgressMonitor)monitor);
        }
    }
}

