/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.contrib.refresh.command;

import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.contrib.refresh.Messages;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;

public class RefreshRepresentation
extends ModelCommand {
    Logger LOGGER = Logger.getLogger(RefreshRepresentation.class);

    public void exec(Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (resource.isLoaded()) {
            resource.unload();
        }
        try {
            resource.load(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Session session = SessionManager.INSTANCE.getSession(resource.getURI(), (IProgressMonitor)subMonitor);
        session.open((IProgressMonitor)subMonitor);
        subMonitor.beginTask(Messages.REFRESH_REMPRESENTATIONS, -1);
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        RefreshRepresentationsCommand cmd = new RefreshRepresentationsCommand(domain, (IProgressMonitor)subMonitor, allRepresentations);
        if (cmd.canExecute()) {
            domain.getCommandStack().execute((Command)cmd);
        }
        subMonitor.subTask(Messages.SAVE_SIRIUS_SESSION);
        session.save((IProgressMonitor)subMonitor);
        subMonitor.subTask(Messages.CLOSING_SIRIUS_SESSION);
        session.close((IProgressMonitor)subMonitor);
        subMonitor.done();
    }
}

