/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.contrib.viewpoints.command;

import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.contrib.viewpoints.Messages;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.Scrutineer;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.viewpoints.scrutinizes.UsedAFViewpoints;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.ViewpointTreeContainer;

public class ViewpointsDetachmentCommand
extends ModelCommand {
    Logger LOGGER = Logger.getLogger(ViewpointsDetachmentCommand.class);

    public void exec(Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        try {
            monitor.beginTask(Messages.REMOVE_VIEWPOINTS, 1);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            ModelScrutinyRegistry.RegistryElement regElt = Scrutineer.getRegistryElement((String)this.getModelAnalysisID());
            UsedAFViewpoints usedVpFinder = this.getUsedAFFinder(regElt);
            if (usedVpFinder != null) {
                ViewpointTreeContainer container = usedVpFinder.getAnalysisResult();
                Collection unSelectedUri = container.getUriToRemove();
                this.cleanUnselectedUris(resource, unSelectedUri, (IProgressMonitor)subMonitor);
                container.dispose();
            }
            subMonitor.worked(1);
            subMonitor.done();
        }
        catch (ModelScrutinyException e) {
            e.printStackTrace();
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void cleanUnselectedUris(Resource resource, Collection<String> unSelectedUri, IProgressMonitor monitor) {
        EList allResources = resource.getResourceSet().getResources();
        for (Resource resource2 : allResources) {
            TreeIterator it = resource2.getAllContents();
            HashSet<EObject> eObjectToRemove = new HashSet<EObject>();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                String current_uri = eObject.eClass().getEPackage().getNsURI();
                if (!unSelectedUri.contains(current_uri)) continue;
                eObjectToRemove.add(eObject);
            }
            if (eObjectToRemove == null || eObjectToRemove.isEmpty()) continue;
            for (EObject eObject2 : eObjectToRemove) {
                monitor.subTask(Messages.bind((String)Messages.REMOVE_OBJECT, (Object[])new Object[]{EcoreUtil.getURI((EObject)eObject2), eObject2.eClass().getEPackage().getNsURI()}));
                EcoreUtil.delete((EObject)eObject2, (boolean)false);
            }
        }
    }

    private UsedAFViewpoints getUsedAFFinder(ModelScrutinyRegistry.RegistryElement regElt) {
        Collection finders = regElt.getFinders();
        for (IScrutinize iFinder : finders) {
            if (!(iFinder instanceof UsedAFViewpoints)) continue;
            return (UsedAFViewpoints)iFinder;
        }
        return null;
    }
}

