/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.services.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.common.utils.URIHelper;
import org.polarsys.kitalpha.ad.services.Activator;
import org.polarsys.kitalpha.ad.services.Messages;
import org.polarsys.kitalpha.ad.services.manager.AlreadyInStateException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class ViewpointManager {
    private static final String STATE_FILENAME = "viewpointManager.state";
    protected static final ViewpointManager INSTANCE;
    private static final Set<String> discarded;
    private static final List<OverallListener> overallListeners;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private static final int ACTIVATED = 1;
    private static final int DEACTIVATED = 2;
    private static final int DISPLAYED = 4;
    private static final int FILTERED = 8;
    private static final Map<ResourceSet, ViewpointManager> instances;
    private final Map<String, List<String>> dependencies = new HashMap<String, List<String>>();
    private final Set<String> activated = new HashSet<String>();
    private final Set<String> managed = new HashSet<String>();
    private ResourceSet target;
    private final StateManager stateManager = new StateManager();

    static {
        discarded = new HashSet<String>();
        overallListeners = new ArrayList<OverallListener>();
        instances = new HashMap<ResourceSet, ViewpointManager>();
        ViewpointManager instance = null;
        try {
            IConfigurationElement[] elts = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.ad.services.viewpoint.manager");
            instance = elts == null || elts.length == 0 ? new ViewpointManager() : (ViewpointManager)elts[0].createExecutableExtension("class");
        }
        catch (CoreException e) {
            AD_Log.getDefault().logError(Messages.Viewpoint_Manager_error_2, (Throwable)e);
            instance = new ViewpointManager();
        }
        INSTANCE = instance;
    }

    public static Resource getViewpoint(String id) {
        Resource[] resourceArray = ViewpointManager.getAvailableViewpoints();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource res = resourceArray[n2];
            if (id.equals(res.getId())) {
                return res;
            }
            ++n2;
        }
        return null;
    }

    public static void pinError(Resource vp) {
        discarded.add(vp.getId());
    }

    public static Resource[] getAvailableViewpoints() {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setDomain("AF");
        searchCriteria.getTags().add("vp");
        Resource[] resources = ResourceReuse.createHelper().getResources(searchCriteria);
        if (discarded.isEmpty()) {
            return resources;
        }
        ArrayList<Resource> result = new ArrayList<Resource>(resources.length);
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource res = resourceArray[n2];
            if (!discarded.contains(res.getId())) {
                result.add(res);
            }
            ++n2;
        }
        return result.toArray(new Resource[result.size()]);
    }

    public boolean isActive(String id) {
        return this.activated.contains(id);
    }

    public boolean isUsed(String id) {
        return this.isActive(id);
    }

    public boolean isFiltered(String id) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void activate(String id) throws ViewpointActivationException {
        vpResource = ViewpointManager.getViewpoint(id);
        if (vpResource == null) {
            throw new ViewpointActivationException(NLS.bind((String)Messages.Viewpoint_Manager_error_3, (Object)id));
        }
        if (this.activated.contains(id)) {
            throw new AlreadyInStateException(NLS.bind((String)Messages.Viewpoint_Manager_error_4, (Object)id));
        }
        set = new ResourceSetImpl();
        try {
            this.doActivate((ResourceSet)set, vpResource);
        }
        finally {
            ** for (r : set.getResources())
        }
lbl-1000:
        // 1 sources

        {
            r.unload();
            continue;
        }
lbl14:
        // 1 sources

        set.getResources().clear();
        this.stateManager.saveState();
    }

    protected void doActivate(ResourceSet set, Resource vpResource) throws ViewpointActivationException {
        this.startBundle(vpResource);
        this.manageDependencies(set, vpResource);
        this.activated.add(vpResource.getId());
        if (Location.WORSPACE.equals((Object)vpResource.getProviderLocation())) {
            this.managed.add(vpResource.getProviderSymbolicName());
        }
        this.fireEvent(vpResource, 1);
    }

    protected void manageDependencies(ResourceSet set, Resource vpResource) throws ViewpointActivationException {
        URI uri = URIHelper.createURI((Resource)vpResource);
        Viewpoint vp = (Viewpoint)set.getEObject(uri, true);
        List<String> vpDependencies = this.dependencies.get(vpResource.getId());
        if (vpDependencies == null) {
            vpDependencies = new ArrayList<String>();
            this.dependencies.put(vpResource.getId(), vpDependencies);
        }
        vpDependencies.clear();
        ArrayList dependencies = new ArrayList(10);
        dependencies.addAll(vp.getDependencies());
        dependencies.addAll(vp.getParents());
        for (Viewpoint dep : dependencies) {
            String id = dep.getId();
            vpDependencies.add(id);
            if (this.activated.contains(id)) continue;
            this.doActivate(set, ViewpointManager.getViewpoint(id));
        }
    }

    protected void startBundle(Resource vpResource) throws ViewpointActivationException {
        String providerSymbolicName = vpResource.getProviderSymbolicName();
        Bundle bundle = Platform.getBundle((String)providerSymbolicName);
        if (bundle == null || this.managed.contains(providerSymbolicName)) {
            this.activateBundle(providerSymbolicName);
            bundle = Platform.getBundle((String)providerSymbolicName);
        }
        if (bundle == null) {
            throw new ViewpointActivationException(NLS.bind((String)Messages.Viewpoint_Manager_error_7, (Object)providerSymbolicName));
        }
        try {
            bundle.start(1);
            Thread.sleep(100L);
        }
        catch (Exception e) {
            throw new ViewpointActivationException(e);
        }
    }

    protected void activateBundle(String id) throws ViewpointActivationException {
        if (Platform.getBundle((String)id) == null) {
            throw new ViewpointActivationException(Messages.Viewpoint_Manager_error_5);
        }
    }

    protected void desactivateBundle(String id) throws ViewpointActivationException {
    }

    public void desactivate(String id) throws ViewpointActivationException {
        Resource vpResource = ViewpointManager.getViewpoint(id);
        if (vpResource == null) {
            throw new ViewpointActivationException(NLS.bind((String)Messages.Viewpoint_Manager_error_3, (Object)id));
        }
        if (!this.activated.contains(id)) {
            throw new AlreadyInStateException(NLS.bind((String)Messages.Viewpoint_Manager_error_6, (Object)id));
        }
        for (Map.Entry<String, List<String>> entry : this.dependencies.entrySet()) {
            if (!entry.getValue().contains(id)) continue;
            throw new ViewpointActivationException(NLS.bind((String)Messages.Viewpoint_Manager_error_8, (Object)id, (Object)entry.getKey()));
        }
        this.dependencies.remove(id);
        String providerSymbolicName = vpResource.getProviderSymbolicName();
        this.desactivateBundle(providerSymbolicName);
        this.activated.remove(id);
        this.fireEvent(vpResource, 2);
        this.stateManager.saveState();
    }

    public static void addOverallListener(OverallListener l) {
        if (overallListeners.contains(l)) {
            return;
        }
        overallListeners.add(l);
    }

    public static void removeOverallListener(OverallListener l) {
        overallListeners.remove(l);
    }

    public void addListener(Listener l) {
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    protected void fireEvent(Resource vpResource, int event) {
        Object l;
        Object[] objectArray = this.listeners.toArray(new Listener[this.listeners.size()]);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            l = objectArray[n2];
            switch (event) {
                case 1: {
                    l.hasBeenActivated(vpResource);
                    break;
                }
                case 2: {
                    l.hasBeenDeactivated(vpResource);
                    break;
                }
                case 8: {
                    l.hasBeenFiltered(vpResource);
                    break;
                }
                case 4: {
                    l.hasBeenDisplayed(vpResource);
                }
            }
            ++n2;
        }
        objectArray = overallListeners.toArray(new OverallListener[overallListeners.size()]);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            l = objectArray[n2];
            switch (event) {
                case 1: {
                    l.hasBeenActivated(this.target, vpResource);
                    break;
                }
                case 2: {
                    l.hasBeenDeactivated(this.target, vpResource);
                    break;
                }
                case 8: {
                    l.hasBeenFiltered(this.target, vpResource);
                    break;
                }
                case 4: {
                    l.hasBeenDisplayed(this.target, vpResource);
                }
            }
            ++n2;
        }
    }

    public void loadState() {
        this.stateManager.loadState();
    }

    public static ViewpointManager getInstance(EObject ctx1) {
        return INSTANCE;
    }

    public static ViewpointManager getInstance(ResourceSet ctx) {
        return INSTANCE;
    }

    public static interface Listener {
        public void hasBeenActivated(Resource var1);

        public void hasBeenDeactivated(Resource var1);

        public void hasBeenFiltered(Resource var1);

        public void hasBeenDisplayed(Resource var1);
    }

    public static interface OverallListener {
        public void hasBeenActivated(Object var1, Resource var2);

        public void hasBeenDeactivated(Object var1, Resource var2);

        public void hasBeenFiltered(Object var1, Resource var2);

        public void hasBeenDisplayed(Object var1, Resource var2);
    }

    public class StateManager {
        private boolean loading = false;

        public void loadState() {
            if (!ViewpointManager.this.activated.isEmpty()) {
                AD_Log.getDefault().logError(Messages.Viewpoint_Manager_error_1);
                return;
            }
            boolean errorInLoading = false;
            this.loading = true;
            try {
                IPath stateLocation = Activator.getDefault().getStateLocation();
                stateLocation = stateLocation.append(ViewpointManager.STATE_FILENAME);
                File file = stateLocation.toFile();
                if (!file.exists()) {
                    return;
                }
                try {
                    ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
                    Set data = (Set)in.readObject();
                    in.close();
                    for (String id : data) {
                        try {
                            ViewpointManager.this.activate(id);
                        }
                        catch (AlreadyInStateException alreadyInStateException) {
                        }
                        catch (Exception e) {
                            AD_Log.getDefault().logError((Throwable)e);
                            errorInLoading = true;
                        }
                    }
                }
                catch (Exception e) {
                    AD_Log.getDefault().logError((Throwable)e);
                }
            }
            finally {
                this.loading = false;
                if (errorInLoading) {
                    this.saveState();
                }
            }
        }

        public void saveState() {
            if (this.loading) {
                return;
            }
            IPath stateLocation = Activator.getDefault().getStateLocation();
            stateLocation = stateLocation.append(ViewpointManager.STATE_FILENAME);
            File file = stateLocation.toFile();
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
                out.writeObject(ViewpointManager.this.activated);
                out.close();
            }
            catch (Exception e) {
                AD_Log.getDefault().logError((Throwable)e);
            }
        }
    }
}

