/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.cadence.ui.api.dialog;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.polarsys.kitalpha.cadence.ui.api.dialog.ColumnValidityLabelProvider;
import org.polarsys.kitalpha.cadence.ui.api.dialog.IParameterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersDialog
extends SelectionDialog {
    private TableViewerColumn values;
    private Object container;
    private final IParameterManager manager;
    private Text descriptionArea;
    private Text validityArea;
    private TableViewer tableViewer;
    private int widthInChars = 100;
    private int vwidthInChars = 10;
    private int heightInChars = 50;
    EditingSupport edit;
    private IStructuredContentProvider contentProvider;
    private CellLabelProvider parameterLabelProvider;
    private CellLabelProvider valueLabelProvider;

    public ParametersDialog(Shell parent, IStructuredContentProvider content_p, ColumnLabelProvider parameter_p, ColumnLabelProvider value_p, IParameterManager manager_p) {
        super(parent);
        this.contentProvider = content_p;
        this.parameterLabelProvider = parameter_p;
        this.valueLabelProvider = value_p;
        this.manager = manager_p;
        this.setTitle("Parameters Configuration");
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(this.heightInChars / 4);
        gd.widthHint = this.convertWidthInCharsToPixels(this.widthInChars);
        this.tableViewer = new TableViewer(parent, this.getStyle());
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(container.getFont());
        String[] columnNames = new String[]{"Name", "Value", "Validity"};
        int vsize = this.convertWidthInCharsToPixels(this.vwidthInChars);
        int size = this.convertWidthInCharsToPixels((this.widthInChars - this.vwidthInChars) / 2);
        int[] columnWidths = new int[]{size, size, vsize};
        int[] columnAlignements = new int[]{16384, 0x1000000, 0x1000000};
        TableColumn[] tableColumn = new TableColumn[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(table, columnAlignements[i]);
            column.setText(columnNames[i]);
            column.setWidth(columnWidths[i]);
            tableColumn[i] = column;
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        TableViewerColumn parameters = new TableViewerColumn(this.tableViewer, tableColumn[0]);
        this.values = new TableViewerColumn(this.tableViewer, tableColumn[1]);
        TableViewerColumn validity = new TableViewerColumn(this.tableViewer, tableColumn[2]);
        CellLabelProvider providerP = this.parameterLabelProvider;
        CellLabelProvider providerV = this.valueLabelProvider;
        ColumnValidityLabelProvider providerVa = new ColumnValidityLabelProvider((Dialog)this, this.manager);
        parameters.setLabelProvider(providerP);
        this.values.setLabelProvider(providerV);
        validity.setLabelProvider((CellLabelProvider)providerVa);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        Group group = new Group(parent, 0);
        group.setText("Selected parameter");
        group.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData();
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(this.heightInChars);
        gd.widthHint = this.convertWidthInCharsToPixels(this.widthInChars);
        group.setLayoutData((Object)gd);
        Label label = new Label((Composite)group, 0);
        label.setText("Description");
        this.descriptionArea = new Text((Composite)group, 2634);
        this.descriptionArea.setEditable(false);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        this.descriptionArea.setLayoutData((Object)gd);
        group = new Group(parent, 0);
        group.setText("Validation");
        group.setLayout((Layout)new GridLayout(2, false));
        label = new Label((Composite)group, 0);
        label.setText("Message(s)");
        this.validityArea = new Text((Composite)group, 2634);
        this.validityArea.setLayoutData((Object)gd);
        this.descriptionArea.setEditable(false);
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)new ParameterTableSelectionChangedListener(this.tableViewer, this.descriptionArea));
        return parent;
    }

    private int getStyle() {
        return 68096;
    }

    public void setInput(Object input) {
        this.tableViewer.setInput(input);
    }

    public Object getInput() {
        return this.tableViewer.getInput();
    }

    public Object getContainer() {
        return this.container;
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public String getDescription() {
        return this.descriptionArea.getText();
    }

    public void setDescription(String text_p) {
        this.descriptionArea.setText(text_p);
    }

    public String getValidity() {
        return this.validityArea.getText();
    }

    public void setValidity(String text_p) {
        this.validityArea.setText(text_p);
    }

    public void setEditingSupport(EditingSupport editing) {
        this.values.setEditingSupport(editing);
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public Map<String, String> getMapFromParametersTable() {
        TableItem[] items;
        HashMap<String, String> params = new HashMap<String, String>();
        TableItem[] tableItemArray = items = this.tableViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            params.put(item.getText(0), item.getText(1));
            ++n2;
        }
        return params;
    }

    protected class ParameterTableSelectionChangedListener
    implements ISelectionChangedListener {
        private TableViewer viewer;
        private Text text;

        public ParameterTableSelectionChangedListener(TableViewer viewer, Text text) {
            this.viewer = viewer;
            this.text = text;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = this.viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object o = ((IStructuredSelection)selection).getFirstElement();
                String string = ParametersDialog.this.manager.getDescription(o) == null ? "Parameter " + ParametersDialog.this.manager.getName(o) : ParametersDialog.this.manager.getDescription(o);
                this.text.setText(string);
            }
        }
    }
}

