/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.egf.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.polarsys.kitalpha.emde.egf.l10n.Messages;
import org.polarsys.kitalpha.emde.extension.utils.ExtensionAnnotationsHelper;

public class ExtensionHelper {
    private static final List<String> javaReservedKeyWords;

    static {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.add("abstract");
        keywords.add("assert");
        keywords.add("boolean");
        keywords.add("break");
        keywords.add("byte");
        keywords.add("case");
        keywords.add("catch");
        keywords.add("char");
        keywords.add("class");
        keywords.add("const");
        keywords.add("continue");
        keywords.add("default");
        keywords.add("do");
        keywords.add("double");
        keywords.add("else");
        keywords.add("enum");
        keywords.add("extends");
        keywords.add("final");
        keywords.add("finally");
        keywords.add("float");
        keywords.add("for");
        keywords.add("goto");
        keywords.add("if");
        keywords.add("implements");
        keywords.add("import");
        keywords.add("instanceof");
        keywords.add("int");
        keywords.add("interface");
        keywords.add("long");
        keywords.add("native");
        keywords.add("new");
        keywords.add("package");
        keywords.add("private");
        keywords.add("protected");
        keywords.add("public");
        keywords.add("return");
        keywords.add("short");
        keywords.add("static");
        keywords.add("strictfp");
        keywords.add("super");
        keywords.add("switch");
        keywords.add("synchronized");
        keywords.add("this");
        keywords.add("throw");
        keywords.add("throws");
        keywords.add("transient");
        keywords.add("try");
        keywords.add("void");
        keywords.add("volatile");
        keywords.add("while");
        keywords.add("false");
        keywords.add("null");
        keywords.add("true");
        javaReservedKeyWords = Collections.unmodifiableList(keywords);
    }

    private ExtensionHelper() {
    }

    public static boolean isJavaKeyword(String name) {
        return javaReservedKeyWords.contains(name.trim().toLowerCase());
    }

    public static boolean isValidJavaName(String name) {
        int length;
        boolean result = false;
        if (name.trim().length() > 0 && (length = name.length()) > 0 && Character.isJavaIdentifierStart(name.codePointAt(0))) {
            result = true;
            int i = Character.offsetByCodePoints(name, 0, 1);
            while (i < length) {
                if (!Character.isJavaIdentifierPart(name.codePointAt(i))) {
                    result = false;
                    break;
                }
                i = Character.offsetByCodePoints(name, i, 1);
            }
        }
        return result;
    }

    public static boolean hasChildCreationExtenders(GenModel genModel) {
        if (genModel == null) {
            return false;
        }
        for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
            if (!genPackage.isChildCreationExtenders()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtensibleProviderFactory(GenModel genModel) {
        if (genModel == null) {
            return false;
        }
        for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
            if (!genPackage.isExtensibleProviderFactory()) continue;
            return true;
        }
        return false;
    }

    public static boolean isTrackResourceModification(GenPackage genPackage) {
        return ExtensionAnnotationsHelper.isTrackResourceModification((EPackage)genPackage.getEcorePackage());
    }

    public static boolean isUseIDAttributes(GenPackage genPackage) {
        return ExtensionAnnotationsHelper.isUseIDAttributes((EPackage)genPackage.getEcorePackage());
    }

    public static boolean isUseUUIDS(GenPackage genPackage) {
        return ExtensionAnnotationsHelper.isUseUUIDS((EPackage)genPackage.getEcorePackage());
    }

    public static boolean isImplemented(EClass eClass, EClass implementedEClass) {
        if (eClass == null || eClass.getName() == null || implementedEClass == null || implementedEClass.getName() == null) {
            return false;
        }
        if (eClass.getEPackage() != null && eClass.getEPackage().getNsURI() != null && implementedEClass.getEPackage() != null && eClass.getEPackage().getNsURI().equals(implementedEClass.getEPackage().getNsURI()) && eClass.getName().equals(implementedEClass.getName())) {
            return true;
        }
        if (implementedEClass.getEPackage() != null) {
            for (EClass superType : eClass.getEAllSuperTypes()) {
                if (superType.getEPackage() == null || superType.getEPackage().getNsURI() == null || superType.getName() == null || !superType.getEPackage().getNsURI().equals(implementedEClass.getEPackage().getNsURI()) || !superType.getName().equals(implementedEClass.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<GenPackage, Map<GenClass, List<GenClass.ChildCreationData>>> getExtendedChildCreationData(GenPackage genPackage) throws CoreException {
        GenModel genModel = genPackage.getGenModel();
        LinkedHashMap<GenPackage, Map<GenClass, List<GenClass.ChildCreationData>>> result = new LinkedHashMap<GenPackage, Map<GenClass, List<GenClass.ChildCreationData>>>();
        List allUsedGenPackagesWithClassifiers = genModel.getAllUsedGenPackagesWithClassifiers();
        for (GenPackage processedGenPackage : ExtensionHelper.getUsedGenPackages(genPackage)) {
            if (!processedGenPackage.hasClassifiers() || allUsedGenPackagesWithClassifiers.contains(processedGenPackage)) continue;
            EcoreUtil.resolveAll((EObject)processedGenPackage);
            genModel.getUsedGenPackages().add((Object)processedGenPackage);
        }
        for (GenPackage processedGenPackage : genModel.getAllUsedGenPackagesWithClassifiers()) {
            for (GenClass genClass : processedGenPackage.getGenClasses()) {
                List allChildCreationData = genClass.getChildCreationData(genModel);
                for (GenClass.ChildCreationData childCreationData : allChildCreationData) {
                    List data;
                    if ((childCreationData.delegatedFeature == null || childCreationData.delegatedFeature.getGenPackage() != genPackage) && (childCreationData.createClassifier.getGenPackage() != genPackage || childCreationData.delegatedFeature != null && !allUsedGenPackagesWithClassifiers.contains(childCreationData.delegatedFeature.getGenPackage()))) continue;
                    GenClass featureClass = childCreationData.createFeature.getGenClass();
                    GenPackage featureGenPackage = genClass.getGenPackage();
                    LinkedHashMap<GenClass, UniqueEList> map = (LinkedHashMap<GenClass, UniqueEList>)result.get(featureGenPackage);
                    if (map == null) {
                        map = new LinkedHashMap<GenClass, UniqueEList>();
                        result.put(featureGenPackage, map);
                    }
                    if ((data = (List)map.get(featureClass)) == null) {
                        data = new UniqueEList();
                        map.put(featureClass, (UniqueEList)data);
                    }
                    data.add(childCreationData);
                }
            }
        }
        return result;
    }

    public static List<GenPackage> getUsedGenPackages(GenPackage genPackage) throws CoreException {
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        ArrayList<GenPackage> genPackages = new ArrayList<GenPackage>();
        if (genPackage == null || genPackage.eResource() == null) {
            return genPackages;
        }
        ResourceSet resourceSet = genPackage.eResource().getResourceSet();
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
        }
        for (String detail : ExtensionAnnotationsHelper.getUsedGenPackages((EPackage)genPackage.getEcorePackage())) {
            URI uri = URI.createURI((String)detail);
            if (uri.isRelative()) {
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.polarsys.kitalpha.emde.egf", 0, NLS.bind((String)Messages.ExtensionHelper_Relative_URI_Error, (Object)genPackage.getEcorePackage().getName(), (Object)detail), null));
            }
            try {
                EObject eObject = resourceSet.getEObject(uri, true);
                if (!(eObject instanceof GenPackage) || genPackages.contains(eObject)) continue;
                GenPackage processedGenPackage = (GenPackage)eObject;
                processedGenPackage.getGenModel().setImportManager(genPackage.getGenModel().getImportManager());
                genPackages.add(processedGenPackage);
            }
            catch (WrappedException we) {
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.polarsys.kitalpha.emde.egf", 0, NLS.bind((String)Messages.ExtensionHelper_URI_Error, (Object)genPackage.getEcorePackage().getName(), (Object)detail), null));
            }
            catch (RuntimeException re) {
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.polarsys.kitalpha.emde.egf", 0, NLS.bind((String)Messages.ExtensionHelper_Resource_Error, (Object)genPackage.getEcorePackage().getName(), (Object)detail), null));
            }
        }
        if (diagnostic.getSeverity() != 0) {
            throw DiagnosticException.toCoreException((DiagnosticException)new DiagnosticException((Diagnostic)diagnostic));
        }
        return genPackages;
    }
}

