/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.contrib.resourcesChecker.command;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.contrib.resourcesChecker.Messages;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;

public class WorkspaceResourceChecker
extends ModelCommand {
    public void exec(Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(Messages.CHECK_ATTRIBUTE_FILES, 1);
        EList resources = resource.getResourceSet().getResources();
        for (Resource resource2 : resources) {
            this.checkAttributes(resource2, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    private void checkAttributes(Resource resource2, IProgressMonitor monitor) throws ModelCommandException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(Messages.bind((String)Messages.CHECK_FILE, (Object)resource2.getURI()), 1);
        URI uri = resource2.getURI();
        if (uri.isPlatformResource()) {
            String platformString = uri.toPlatformString(true);
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
            if (iResource != null && !iResource.isAccessible()) {
                throw new ModelCommandException(Messages.bind((String)Messages.RESOURCE_INACCESSIBLE, (Object)iResource.getName()));
            }
            if (iResource != null && iResource.getResourceAttributes().isReadOnly()) {
                throw new ModelCommandException(Messages.bind((String)Messages.RESOURCE_READONLY, (Object)iResource.getName()));
            }
        }
    }
}

