/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.dialog;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.polarsys.kitalpha.ad.integration.sirius.dialog.ViewpointsTableContentProvider;
import org.polarsys.kitalpha.ad.integration.sirius.dialog.ViewpointsTableLabelProvider;
import org.polarsys.kitalpha.ad.integration.sirius.dialog.ViewpointsTableLazyCellModifier;

public class ViewpointSelectionDialog
extends TitleAreaDialog {
    private static final String DEFAULT_MESSAGE = "Change viewpoints selection status (see tooltip for details about each viewpoint)";
    public static final String[] COLUMNS = new String[]{" ", "icon", "Viewpoint"};
    private final SortedMap<Viewpoint, Boolean> viewpointsMap;
    private final Map<Viewpoint, Boolean> originalViewpointsMap = new HashMap<Viewpoint, Boolean>();

    public ViewpointSelectionDialog(Shell parentShell, SortedMap<Viewpoint, Boolean> viewpointsMap) {
        super(parentShell);
        this.viewpointsMap = viewpointsMap;
        this.originalViewpointsMap.putAll(viewpointsMap);
    }

    private boolean validate() {
        HashSet<String> selectedURIs = new HashSet<String>();
        HashMap missings = new HashMap();
        for (Map.Entry<Viewpoint, Boolean> entry : this.viewpointsMap.entrySet()) {
            Viewpoint vp;
            Option uri;
            if (!entry.getValue().booleanValue() || !(uri = new ViewpointQuery(vp = entry.getKey()).getViewpointURI()).some()) continue;
            selectedURIs.add(((URI)uri.get()).toString().trim());
            missings.remove(((URI)uri.get()).toString().trim());
            for (RepresentationExtensionDescription extension : new ViewpointQuery(vp).getAllRepresentationExtensionDescriptions()) {
                String extended = extension.getViewpointURI();
                if (extended.contains("*") || selectedURIs.contains(extended.trim())) continue;
                missings.put(extended.trim(), null);
            }
        }
        if (missings.isEmpty()) {
            this.setErrorMessage(null);
            this.setMessage(DEFAULT_MESSAGE);
            return true;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Missing dependencies: ");
        for (String uri : missings.keySet()) {
            builder.append('\'').append(new Path(uri).lastSegment()).append("' ");
        }
        this.setErrorMessage(builder.toString());
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Viewpoints Selection");
        this.setTitle("Selected viewpoints");
        this.setMessage(DEFAULT_MESSAGE);
        Composite control = SWTUtil.createCompositeBothFill((Composite)parent, (int)1, (boolean)false);
        TableViewer tableViewer = new TableViewer(control, 67584);
        ViewpointsTableLazyCellModifier cellModifier = new ViewpointsTableLazyCellModifier(this.viewpointsMap, tableViewer){

            @Override
            public void modify(Object element, String property, Object value) {
                super.modify(element, property, value);
                ViewpointSelectionDialog.this.getButton(0).setEnabled(ViewpointSelectionDialog.this.validate());
            }
        };
        tableViewer.getTable().setFont(parent.getFont());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        Table table = tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn tc0 = new TableColumn(table, 0x1000000, 0);
        tc0.setWidth(30);
        TableColumn tc1 = new TableColumn(table, 0x1000000, 1);
        tc1.setWidth(30);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 16384, 2);
        column.getColumn().setWidth(450);
        table.setSize(new Point(table.getSize().x, 510));
        CellEditor[] editors = new CellEditor[3];
        editors[0] = new CheckboxCellEditor((Composite)table);
        int i = 1;
        while (i < 3) {
            editors[i] = null;
            ++i;
        }
        tableViewer.setColumnProperties(COLUMNS);
        tableViewer.setCellEditors(editors);
        tableViewer.setCellModifier((ICellModifier)cellModifier);
        tableViewer.setContentProvider((IContentProvider)new ViewpointsTableContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new ViewpointsTableLabelProvider(this.viewpointsMap));
        tableViewer.setComparator(new ViewerComparator());
        tableViewer.setInput(this.viewpointsMap.keySet());
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        return control;
    }

    public Map<Viewpoint, Boolean> getChanges() {
        HashMap<Viewpoint, Boolean> result = new HashMap<Viewpoint, Boolean>();
        for (Map.Entry<Viewpoint, Boolean> entry : this.viewpointsMap.entrySet()) {
            if (entry.getValue() == this.originalViewpointsMap.get(entry.getKey())) continue;
            result.put(entry.getKey(), (Boolean)this.viewpointsMap.get(entry.getKey()));
        }
        return result;
    }
}

