/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.listeners;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CompositeFilterApplicationBuilder;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.emde.extension.ModelExtensionOverallListener;

public class DiagramUpdater
implements ModelExtensionOverallListener {
    public void modelEnabled(Object ctx, String nsURI) {
        this.refresh();
    }

    public void modelDisabled(Object ctx, String nsURI) {
        this.refresh();
    }

    private void refresh() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            DDiagramEditor dEditor;
            DRepresentation representation;
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor != null && editor instanceof DDiagramEditor && (representation = (dEditor = (DDiagramEditor)editor).getRepresentation()) instanceof DDiagram) {
                DDiagram diagram = (DDiagram)representation;
                this.updateDiagram(dEditor.getSession(), diagram);
            }
            ++n2;
        }
    }

    public void updateDiagram(Session session, final DDiagram diagram) {
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

            protected void doExecute() {
                CompositeFilterApplicationBuilder builder = new CompositeFilterApplicationBuilder(diagram);
                builder.computeCompositeFilterApplications();
            }
        });
    }
}

