/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.listeners;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.IProgressService;
import org.polarsys.kitalpha.ad.common.utils.URIHelper;
import org.polarsys.kitalpha.ad.integration.sirius.Activator;
import org.polarsys.kitalpha.ad.integration.sirius.listeners.SiriusHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public final class SiriusViewpointActivationManager
implements ViewpointManager.OverallListener {
    public void hasBeenDeactivated(Object ctx, Resource vp) {
        this.updateActiveViewpoint(ctx, this.getURI(vp), false);
    }

    public void hasBeenActivated(Object ctx, Resource vp) {
        this.updateActiveViewpoint(ctx, this.getURI(vp), true);
    }

    public void hasBeenFiltered(Object ctx, Resource vp) {
        this.updateActiveViewpoint(ctx, this.getURI(vp), false);
    }

    public void hasBeenDisplayed(Object ctx, Resource vp) {
        this.updateActiveViewpoint(ctx, this.getURI(vp), true);
    }

    private URI getURI(Resource res) {
        return URIHelper.createURI((Resource)res);
    }

    private void updateActiveViewpoint(Object ctx, URI vpURI, boolean activate) {
        ViewpointSelectionCallback callback = new ViewpointSelectionCallback();
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
            Viewpoint vp = (Viewpoint)domain.getResourceSet().getEObject(vpURI, true);
            org.eclipse.sirius.viewpoint.description.Viewpoint genericVp = (org.eclipse.sirius.viewpoint.description.Viewpoint)domain.getResourceSet().getEObject(Activator.GENERIC_VP_URI, true);
            Set<org.eclipse.sirius.viewpoint.description.Viewpoint> viewpoints = SiriusHelper.getViewpoints(vp);
            if (viewpoints.isEmpty()) continue;
            HashSet<org.eclipse.sirius.viewpoint.description.Viewpoint> newSelectedViewpoints = new HashSet<org.eclipse.sirius.viewpoint.description.Viewpoint>();
            Set<org.eclipse.sirius.viewpoint.description.Viewpoint> newDeselectedViewpoints = SiriusHelper.EMPTY_SET;
            newSelectedViewpoints.add(genericVp);
            if (activate) {
                newSelectedViewpoints.addAll(viewpoints);
            } else {
                newDeselectedViewpoints = viewpoints;
            }
            ChangeViewpointSelectionCommand command = new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)callback, newSelectedViewpoints, newDeselectedViewpoints, (IProgressMonitor)new NullProgressMonitor());
            this.execute(domain, (RecordingCommand)command);
        }
    }

    public void execute(final TransactionalEditingDomain domain, final RecordingCommand command) {
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        try {
            ps.run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    monitor.beginTask("Apply new viewpoints selection...", 1);
                    domain.getCommandStack().execute((Command)command);
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getSymbolicName(), "Error while starting bundle", (Throwable)e));
        }
    }
}

