/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.polarsys.kitalpha.ad.common.utils.URIFix;
import org.polarsys.kitalpha.ad.integration.sirius.Activator;
import org.polarsys.kitalpha.ad.integration.sirius.providers.SiriusSelectionProvider;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Service;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.edit.provider.ServiceItemProvider;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.edit.provider.ViewpointItemProvider;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.edit.provider.ViewpointItemProviderAdapterFactory;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ModelManager;
import org.polarsys.kitalpha.ad.viewpoint.integration.services.Implementations;
import org.polarsys.kitalpha.ad.viewpoint.integration.services.ServiceImplementation;
import org.polarsys.kitalpha.ad.viewpoint.ui.provider.AFSelectionProvider;
import org.polarsys.kitalpha.ad.viewpoint.utils.ModelAccessor;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class DynamicMenuAction
implements IMenuCreator,
IObjectActionDelegate {
    private static final String MGR = "mgr";
    private static final String ACTION = "action";
    private Shell shell;
    private IWorkbenchPartSite site;
    private AFSelectionProvider selectionProvider = new SiriusSelectionProvider();
    private SelectionListener listener = new SelectionListener(){

        public void widgetSelected(SelectionEvent ee) {
            try {
                MenuItem menuItem = (MenuItem)ee.getSource();
                Service action = (Service)menuItem.getData(DynamicMenuAction.ACTION);
                ModelManager vpMgr = (ModelManager)menuItem.getData(DynamicMenuAction.MGR);
                ServiceImplementation impl = Implementations.getInstance((Service)action);
                if (impl == null) {
                    MessageDialog.openError((Shell)DynamicMenuAction.this.shell, (String)"Error with service", (String)("An error occured while loading viewpoint service:" + action.getId()));
                } else {
                    impl.run(action, new ModelAccessor(vpMgr), DynamicMenuAction.this.selectionProvider.getSelection().toArray());
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)DynamicMenuAction.this.shell, (String)"Error with service", (String)"An error occured while loading viewpoint service");
                Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getSymbolicName(), "Error with service", (Throwable)e));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.site = targetPart.getSite();
        this.shell = this.site.getShell();
        action.setMenuCreator((IMenuCreator)this);
    }

    public void dispose() {
        this.selectionProvider.dispose();
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        final Menu dynamicMenu = new Menu(parent);
        dynamicMenu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                if (!event.widget.isDisposed()) {
                    MenuItem[] menuItemArray = dynamicMenu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        item.dispose();
                        ++n2;
                    }
                    DynamicMenuAction.this.fillMenu(dynamicMenu);
                }
            }
        });
        return dynamicMenu;
    }

    private void fillMenu(Menu dynamicMenu) {
        LinkedHashMap<Viewpoint, ModelManager> vp2mgr = new LinkedHashMap<Viewpoint, ModelManager>();
        HashMap<Viewpoint, List<ViewpointElement>> vp2elt = new HashMap<Viewpoint, List<ViewpointElement>>();
        this.computeActiveServices(vp2mgr, vp2elt);
        ViewpointItemProviderAdapterFactory adapterFactory = new ViewpointItemProviderAdapterFactory();
        ViewpointItemProvider provider = (ViewpointItemProvider)adapterFactory.createViewpointAdapter();
        Object url = provider.getImage(null);
        Image vpImage = ExtendedImageRegistry.getInstance().getImage(url);
        url = ((ServiceItemProvider)adapterFactory.createServiceAdapter()).getImage(null);
        Image actionImage = ExtendedImageRegistry.getInstance().getImage(url);
        for (Viewpoint vp : vp2mgr.keySet()) {
            ModelManager vpMgr = (ModelManager)vp2mgr.get(vp);
            if (!vp2elt.containsKey(vp)) continue;
            MenuItem mi = new MenuItem(dynamicMenu, 64);
            mi.setImage(vpImage);
            mi.setText(vp.getName());
            mi.setData((Object)vp);
            Menu subMenu = new Menu(dynamicMenu);
            mi.setMenu(subMenu);
            for (ViewpointElement elt : (List)vp2elt.get(vp)) {
                MenuItem smi = new MenuItem(subMenu, 8);
                smi.setText(elt.getName() == null ? "no name" : elt.getName());
                smi.setData(ACTION, (Object)elt);
                smi.setData(MGR, (Object)vpMgr);
                smi.addSelectionListener(this.listener);
                smi.setImage(actionImage);
            }
        }
    }

    public Viewpoint[] getAvailableViewpoints() {
        ArrayList<Viewpoint> vps = new ArrayList<Viewpoint>();
        Resource[] resources = ViewpointManager.getAvailableViewpoints();
        ResourceSetImpl set = new ResourceSetImpl();
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            String path2 = resource.getPath();
            if (path2 != null && !"".equals(path2)) {
                URI uri = URIFix.createPlatformPluginURI((String)path2, (boolean)false);
                Viewpoint vp = (Viewpoint)set.getEObject(uri, true);
                vps.add(vp);
            }
            ++n2;
        }
        Viewpoint[] array = vps.toArray(new Viewpoint[vps.size()]);
        return array;
    }

    private void computeActiveServices(Map<Viewpoint, ModelManager> vp2mgr, Map<Viewpoint, List<ViewpointElement>> vp2elt) {
        Viewpoint[] viewpointArray = this.sort(this.getAvailableViewpoints());
        int n = viewpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Viewpoint vp = viewpointArray[n2];
            if (!vp.isAbstract() && ViewpointManager.getInstance(null).isActive(vp.getId())) {
                ModelManager vpMgr = ModelManager.createWorkspaceManager((Viewpoint)vp);
                vp2mgr.put(vp, vpMgr);
                for (ViewpointElement elt : this.sort(vpMgr.getServiceHandler().getElements())) {
                    try {
                        Service action = (Service)elt;
                        ServiceImplementation impl = Implementations.getInstance((Service)action);
                        if (impl == null || !impl.canRun(action, new ModelAccessor(vpMgr), this.selectionProvider.getSelection().toArray())) continue;
                        List<ViewpointElement> list = vp2elt.get(vp);
                        if (list == null) {
                            list = new ArrayList<ViewpointElement>();
                            vp2elt.put(vp, list);
                        }
                        list.add(elt);
                    }
                    catch (Exception e1) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getSymbolicName(), "Error with service: " + ((Service)elt).getId(), (Throwable)e1));
                    }
                }
            }
            ++n2;
        }
    }

    private Viewpoint[] sort(Viewpoint[] vps) {
        Arrays.sort(vps, new Comparator<Viewpoint>(){

            @Override
            public int compare(Viewpoint arg0, Viewpoint arg1) {
                String name0 = arg0.getName() == null ? "" : arg0.getName();
                String name1 = arg1.getName() == null ? "" : arg1.getName();
                return name0.compareTo(name1);
            }
        });
        return vps;
    }

    private List<ViewpointElement> sort(List<ViewpointElement> elements) {
        Collections.sort(elements, new Comparator<ViewpointElement>(){

            @Override
            public int compare(ViewpointElement arg0, ViewpointElement arg1) {
                String name0 = arg0.getName() == null ? "" : arg0.getName();
                String name1 = arg1.getName() == null ? "" : arg1.getName();
                return name0.compareTo(name1);
            }
        });
        return elements;
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

