/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.views.tabs;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.polarsys.kitalpha.ad.integration.sirius.model.SiriusFactory;
import org.polarsys.kitalpha.ad.integration.sirius.model.SiriusRepresentation;
import org.polarsys.kitalpha.ad.integration.sirius.model.edit.provider.IntegrationEditPlugin;
import org.polarsys.kitalpha.ad.integration.sirius.views.tabs.SiriusContentProvider;
import org.polarsys.kitalpha.ad.integration.sirius.views.tabs.SiriusLabelProvider;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.RepresentationElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IRepresentationHandler;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.dialogs.EditorHelper;
import org.polarsys.kitalpha.ad.viewpoint.ui.dialogs.ModelFileDialog;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.AFLabelProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.AbstractTab;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.ResourceTableSorter;

public class SiriusTab
extends AbstractTab {
    private static final String NAME_COLUMN = "name";
    private TableViewer odesignViewer;
    private Button addBtn;
    private Button deleteBtn;
    private Button viewBtn;

    public SiriusTab() {
        super((AFLabelProvider)new SiriusLabelProvider());
    }

    public ISelectionProvider getSelectionProvider() {
        return this.odesignViewer;
    }

    public void createTab(FormToolkit toolkit, CTabFolder folder) {
        Composite composite = this.createTab(toolkit, folder, "Sirius models", IntegrationEditPlugin.INSTANCE.getImage("full/obj16/SiriusRepresentation"));
        GridLayout clayout = new GridLayout();
        clayout.numColumns = 2;
        composite.setLayout((Layout)clayout);
        this.odesignViewer = new TableViewer(composite, 67584);
        final Table table = this.odesignViewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        AbstractTab.SelectionListener2 headerListener = new AbstractTab.SelectionListener2(this){

            public void doWidgetSelected(SelectionEvent e) {
                TableColumn newSortColumn;
                TableColumn currentSortColumn = table.getSortColumn();
                if (currentSortColumn.equals(newSortColumn = (TableColumn)e.getSource())) {
                    int sortDirection = table.getSortDirection();
                    table.setSortDirection(sortDirection == 128 ? 1024 : 128);
                } else {
                    table.setSortColumn(newSortColumn);
                    table.setSortDirection(1024);
                }
                SiriusTab.this.odesignViewer.refresh();
            }
        };
        TableViewerColumn nameColumn = new TableViewerColumn(this.odesignViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 90, true));
        nameColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        nameColumn.getColumn().setText("Model paths");
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setData((Object)0);
        table.setSortColumn(nameColumn.getColumn());
        table.setSortDirection(1024);
        this.odesignViewer.setColumnProperties(new String[]{NAME_COLUMN});
        this.odesignViewer.setContentProvider((IContentProvider)SiriusContentProvider.INSTANCE);
        this.odesignViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.odesignViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof SiriusRepresentation;
            }
        });
        this.odesignViewer.setSorter((ViewerSorter)new ResourceTableSorter());
        Composite btnBar = toolkit.createComposite(composite);
        btnBar.setLayout((Layout)new GridLayout());
        this.addBtn = toolkit.createButton(btnBar, "", 8);
        this.addBtn.setImage(Activator.getDefault().getImage("icons/add.gif"));
        this.addBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            public void doWidgetSelected(SelectionEvent e) {
                IRepresentationHandler representationHandler = SiriusTab.this.modelManager.getRepresentationHandler();
                URI uri = SiriusTab.this.viewpoint.eResource().getURI();
                String segment = uri.segment(1);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject project = root.getProject(segment);
                ModelFileDialog dialog = new ModelFileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), project, "*.odesign");
                if (dialog.open() == 0) {
                    ResourceSet resourceSet = SiriusTab.this.viewpoint.eResource().getResourceSet();
                    ArrayList<SiriusRepresentation> representations = new ArrayList<SiriusRepresentation>();
                    for (URI euri : dialog.getResult()) {
                        Resource resource = resourceSet.getResource(euri, true);
                        for (EObject eobj : resource.getContents()) {
                            if (!(eobj instanceof Group)) continue;
                            SiriusRepresentation representation = SiriusFactory.eINSTANCE.createSiriusRepresentation();
                            representation.setOdesign((Group)eobj);
                            representations.add(representation);
                        }
                    }
                    representationHandler.addRepresentations(representations);
                }
            }
        });
        this.deleteBtn = toolkit.createButton(btnBar, "", 8);
        this.deleteBtn.setImage(Activator.getDefault().getImage("icons/delete.gif"));
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            public void doWidgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)SiriusTab.this.odesignViewer.getSelection();
                ArrayList<RepresentationElement> packages = new ArrayList<RepresentationElement>();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    packages.add((RepresentationElement)obj);
                    ++n2;
                }
                IRepresentationHandler representationHandler = SiriusTab.this.modelManager.getRepresentationHandler();
                representationHandler.removeRepresentations(packages);
            }
        });
        this.viewBtn = toolkit.createButton(btnBar, "", 8);
        this.viewBtn.setImage(Activator.getDefault().getImage("icons/viewFile.gif"));
        this.viewBtn.setEnabled(false);
        this.viewBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            public void doWidgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)SiriusTab.this.odesignViewer.getSelection();
                SiriusRepresentation obj = (SiriusRepresentation)selection.getFirstElement();
                Group odesign = obj.getOdesign();
                URI uri = odesign.eResource().getURI();
                try {
                    EditorHelper.openEditor((URI)uri);
                }
                catch (PartInitException e1) {
                    Activator.getDefault().logError((Throwable)e1);
                }
            }
        });
        this.odesignViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SiriusTab.this.updateButtons((IStructuredSelection)event.getSelection());
            }
        });
    }

    public void init() {
        IRepresentationHandler representationHandler = this.modelManager.getRepresentationHandler();
        if (representationHandler != null) {
            this.odesignViewer.setInput((Object)representationHandler);
        }
        this.workspaceHasChanged();
    }

    public void workspaceHasChanged() {
        super.workspaceHasChanged();
        this.odesignViewer.refresh();
        this.updateButtons((IStructuredSelection)this.odesignViewer.getSelection());
    }

    private void updateButtons(IStructuredSelection selection) {
        boolean readOnly = this.getModelManager().getResourceManager().isReadOnly() || this.getModelManager().isLocal();
        this.addBtn.setEnabled(!readOnly);
        this.deleteBtn.setEnabled(!readOnly && !selection.isEmpty());
        if (selection.size() == 1) {
            SiriusRepresentation representation = (SiriusRepresentation)selection.getFirstElement();
            this.viewBtn.setEnabled(representation.getOdesign() != null && !representation.getOdesign().eIsProxy());
        } else {
            this.viewBtn.setEnabled(false);
        }
    }
}

