/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.callback;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.nature.NatureAddingEditorCallback;
import org.eclipse.xtext.builder.nature.ToggleXtextNatureAction;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.generator.IViewpointSynchronizer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.callback.Messages;

public class CommonEditorCallback
extends NatureAddingEditorCallback {
    protected Logger logger = Logger.getLogger(CommonEditorCallback.class);
    protected XtextEditor currentEditor;
    @Inject
    private ToggleXtextNatureAction toggleNature;
    @Inject
    private Injector injector;
    private boolean isResourceClean = true;
    private Map<String, String> messages = null;
    private StringBuffer logMessages = null;
    @Inject
    private IResourceSetProvider resourceSetProvider;

    public Injector getInjector() {
        return this.injector;
    }

    public IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    public void afterCreatePartControl(XtextEditor editor) {
        if (this.currentEditor != editor) {
            throw new IllegalStateException(Messages.CommonEditorCallback_MultipleInstancesError);
        }
        IResource resource = editor.getResource();
        if (resource != null && !this.toggleNature.hasNature(resource.getProject()) && resource.getProject().isAccessible() && !resource.getProject().isHidden()) {
            this.toggleNature.toggleNature(resource.getProject());
        }
    }

    public void beforeDispose(XtextEditor editor) {
        if (this.currentEditor != editor) {
            throw new IllegalStateException(Messages.CommonEditorCallback_MultipleInstancesError);
        }
        this.currentEditor = null;
    }

    public boolean onValidateEditorInputState(XtextEditor editor) {
        if (this.currentEditor != editor) {
            throw new IllegalStateException(Messages.CommonEditorCallback_MultipleInstancesError);
        }
        return this.currentEditor.getDirtyStateEditorSupport().isEditingPossible((DirtyStateEditorSupport.IDirtyStateEditorSupportClient)this.currentEditor);
    }

    public void beforeSetInput(XtextEditor editor) {
    }

    public void afterSetInput(XtextEditor editor) {
        if (this.currentEditor != null) {
            if (this.currentEditor != editor) {
                throw new IllegalStateException(Messages.CommonEditorCallback_MultipleInstancesError);
            }
        } else {
            this.currentEditor = editor;
        }
    }

    public void removeVerifyListener(VerifyListener listener) {
        ISourceViewer sourceViewer = this.currentEditor.getInternalSourceViewer();
        StyledText widget = sourceViewer.getTextWidget();
        if (widget != null) {
            widget.removeVerifyListener(listener);
        }
    }

    public void afterSave(XtextEditor editor) {
        if (this.currentEditor != editor) {
            throw new IllegalStateException(Messages.CommonEditorCallback_MultipleInstancesError);
        }
        final XtextEditor current = editor;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IFile file = (IFile)current.getEditorInput().getAdapter(IFile.class);
                CommonEditorCallback.this.doSynchronize(file);
            }
        };
        if (runnable != null) {
            this.update(runnable);
        }
    }

    protected boolean doSynchronize(IFile file) {
        XtextResourceSet resourceSet;
        boolean result;
        block10: {
            result = false;
            resourceSet = (XtextResourceSet)this.getInjector().getInstance(XtextResourceSet.class);
            IViewpointSynchronizer generator = (IViewpointSynchronizer)this.getInjector().getInstance(IViewpointSynchronizer.class);
            String projectName = this.getProject(file).getName();
            EObject targetObject = ResourceHelper.loadStandaloneResource((ResourceSet)resourceSet, (String)projectName);
            if (targetObject != null) {
                List<EObject> inputObjects = this.loadInputModels(file, (ResourceSet)resourceSet);
                this.isResourceClean = true;
                if (this.validate(inputObjects)) {
                    EObject synchronizedObject = generator.synchronize(inputObjects, targetObject);
                    if (synchronizedObject != null) {
                        try {
                            try {
                                HashMap<String, String> saveOptions = new HashMap<String, String>();
                                saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
                                synchronizedObject.eResource().save(saveOptions);
                                result = true;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                inputObjects.clear();
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            inputObjects.clear();
                            throw throwable;
                        }
                        inputObjects.clear();
                    }
                } else if (this.messages != null && this.logMessages != null) {
                    this.logger.error((Object)this.flattenMessages(this.messages));
                    this.logger.error((Object)this.logMessages);
                }
            }
        }
        resourceSet.eSetDeliver(false);
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
        return result;
    }

    protected boolean validate(List<EObject> inputObjects) {
        for (EObject current : inputObjects) {
            if (this.validate(current)) continue;
            return false;
        }
        return true;
    }

    protected boolean validate(EObject object) {
        ArrayList diagnostics = new ArrayList();
        IConcreteSyntaxValidator concreteSyntaxValidator = ((XtextResource)object.eResource()).getConcreteSyntaxValidator();
        concreteSyntaxValidator.validateRecursive(object, (IConcreteSyntaxValidator.IDiagnosticAcceptor)new IConcreteSyntaxValidator.DiagnosticListAcceptor(diagnostics), new HashMap());
        return diagnostics.isEmpty();
    }

    protected List<EObject> loadInputModels(IFile file, ResourceSet resourceSet) {
        Iterable<Object> inputModels = Collections.emptyList();
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadDataResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadConfigurationResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadUIResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadDiagramResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndloadBuildResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadServicesResource((IFile)file, (ResourceSet)resourceSet));
        inputModels = Iterables.concat(inputModels, (Iterable)ResourceHelper.validateAndLoadActivityexplorerResource((IFile)file, (ResourceSet)resourceSet));
        return Lists.newArrayList(inputModels);
    }

    protected List<URI> getReferencedAspects(IFile file) {
        ResourceSetImpl fakeResourceSet = new ResourceSetImpl();
        ArrayList<URI> uris = new ArrayList<URI>();
        EObject viewpoint = (EObject)ResourceHelper.loadPrimaryResource((IFile)file, (ResourceSet)fakeResourceSet).get(0);
        EList eCrossReferences = viewpoint.eCrossReferences();
        for (EObject object : eCrossReferences) {
            URI uri = EcoreUtil.getURI((EObject)object);
            if (!uri.hasFragment()) continue;
            uris.add(uri.trimFragment());
        }
        return uris;
    }

    public final IProject getProject(IFile file) {
        return file.getProject();
    }

    protected void update(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            Display display = windows[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    protected boolean canSynchronize(IFile file, String projectName) {
        XtextResourceSet resourceSet = (XtextResourceSet)this.getInjector().getInstance(XtextResourceSet.class);
        this.loadInputModels(file, (ResourceSet)resourceSet);
        ResourceHelper.loadPrimaryResource((IFile)file, (ResourceSet)resourceSet);
        this.createOrReinitializeMessagesBuffer();
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            if (!resource.getURI().isPlatformResource() || !this.holdInPoject(resource.getURI(), projectName)) continue;
            EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
            this.isResourceClean &= this.handleXtextResourceErrors(resource);
            if (this.isResourceClean) continue;
            this.isResourceClean &= this.handleEMFValidationErrors(resource);
        }
        resourceSet.eSetDeliver(false);
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
        return this.isResourceClean;
    }

    private boolean holdInPoject(URI uri, String projectName) {
        String resourceProjectName = uri.segment(1);
        return resourceProjectName != null && resourceProjectName.equals(projectName);
    }

    private void createOrReinitializeMessagesBuffer() {
        if (this.messages == null) {
            this.messages = new HashMap<String, String>();
        } else {
            this.messages.clear();
        }
        if (this.logMessages == null) {
            this.logMessages = new StringBuffer();
        } else {
            this.logMessages.setLength(0);
        }
    }

    private boolean handleEMFValidationErrors(Resource resource) {
        Diagnostic result;
        EList content = resource.getContents();
        if (content != null && !content.isEmpty() && (result = Diagnostician.INSTANCE.validate(EcoreUtil.getRootContainer((EObject)((EObject)content.get(0))))).getSeverity() == 4) {
            String wsResourceName = resource.getURI().lastSegment();
            this.assembleValidationMessages(result, wsResourceName);
            return false;
        }
        return true;
    }

    private void assembleValidationMessages(Diagnostic result, String resourceName) {
        List children;
        List list = children = result != null ? result.getChildren() : null;
        if (children != null && !children.isEmpty()) {
            for (Diagnostic diagnostic : children) {
                if (diagnostic.getSeverity() != 4) continue;
                if (!this.messages.containsKey(resourceName)) {
                    this.messages.put("[" + resourceName + "] ", "contains error after the modifications. See the log error message for more details\n");
                }
                this.logMessages.append("\n[").append(resourceName).append("] ");
                this.logMessages.append(diagnostic.getMessage());
                this.logMessages.append("\n");
                this.assembleValidationMessages(diagnostic, resourceName);
            }
        }
    }

    private boolean handleXtextResourceErrors(Resource resource) {
        EList diagnostics = resource.getErrors();
        if (diagnostics != null && !diagnostics.isEmpty()) {
            String wsResourceName = resource.getURI().lastSegment();
            this.assembleMessages((EList<Resource.Diagnostic>)diagnostics, wsResourceName);
            return false;
        }
        return true;
    }

    private void assembleMessages(EList<Resource.Diagnostic> errors, String resourceName) {
        for (Resource.Diagnostic diagnostic : errors) {
            if (!this.messages.containsKey(resourceName)) {
                this.messages.put("[" + resourceName + "] ", "contains error after the modifications. See the log error for more details\n");
            }
            this.logMessages.append("[").append(resourceName).append("] ");
            this.logMessages.append(diagnostic.getMessage());
            this.logMessages.append("\n");
        }
    }

    private String flattenMessages(Map<String, String> messages) {
        StringBuffer tmp = new StringBuffer();
        for (String key : messages.keySet()) {
            tmp.append(key).append(messages.get(key));
        }
        return tmp.toString();
    }
}

