/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.templates.AbstractTemplateVariableResolver;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;

public class CommonTemplateVariableResolver
extends AbstractTemplateVariableResolver {
    public static final String FILE_NAME = "fileName";
    public static final String FILE_NAME_DESCRIPTION = "File name";
    public static final String SHORT_NAME = "shortName";
    public static final String SHORT_NAME_DESCRIPTION = "Viewpoint short name";
    public static final String VIEWPOINT_NAME = "viewpointName";
    public static final String VIEWPOINT_NAME_DESCRIPTION = "Viewpoint Complete Name";

    public List<String> resolveValues(TemplateVariable variable, XtextTemplateContext xtextTemplateContext) {
        return null;
    }

    public static class FileName
    extends SimpleTemplateVariableResolver {
        public FileName() {
            super(CommonTemplateVariableResolver.FILE_NAME, CommonTemplateVariableResolver.FILE_NAME_DESCRIPTION);
        }

        protected String resolve(TemplateContext context) {
            XtextTemplateContext castedContext = (XtextTemplateContext)context;
            XtextDocument document = (XtextDocument)castedContext.getDocument();
            URI resourceURI = document.getResourceURI();
            String lastSegment = resourceURI.trimFileExtension().lastSegment();
            return lastSegment != null ? lastSegment : CommonTemplateVariableResolver.FILE_NAME;
        }
    }

    public static class ShortName
    extends SimpleTemplateVariableResolver {
        public ShortName() {
            super(CommonTemplateVariableResolver.SHORT_NAME, CommonTemplateVariableResolver.SHORT_NAME_DESCRIPTION);
        }

        protected String resolve(TemplateContext context) {
            XtextTemplateContext castedContext = (XtextTemplateContext)context;
            XtextDocument document = (XtextDocument)castedContext.getDocument();
            URI uri = document.getResourceURI();
            String lastSegment = uri != null ? uri.trimFileExtension().lastSegment() : null;
            String shortName = lastSegment != null ? lastSegment.substring(0, lastSegment.indexOf(".")) : null;
            return lastSegment != null ? shortName : CommonTemplateVariableResolver.SHORT_NAME;
        }
    }

    public static class ViewpointName
    extends SimpleTemplateVariableResolver {
        protected ViewpointName() {
            super(CommonTemplateVariableResolver.VIEWPOINT_NAME, CommonTemplateVariableResolver.VIEWPOINT_NAME_DESCRIPTION);
        }

        protected String resolve(TemplateContext context) {
            XtextTemplateContext castedContext = (XtextTemplateContext)context;
            XtextDocument document = (XtextDocument)castedContext.getDocument();
            URI resourceURI = document.getResourceURI();
            String _projectName = resourceURI.segment(1);
            String projectName = _projectName.substring(0, _projectName.lastIndexOf("."));
            return projectName != null ? projectName : CommonTemplateVariableResolver.VIEWPOINT_NAME;
        }
    }
}

