/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.diagram.javaaction;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.emde.diagram.Activator;
import org.polarsys.kitalpha.emde.diagram.javaaction.AbstractEmdeExternalJavaAction;
import org.polarsys.kitalpha.emde.diagram.services.ExtensibilityService;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public class NewExtendedElementAction
extends AbstractEmdeExternalJavaAction {
    public static final String SPACE = " ";
    private static final String OWNER = "owner";
    private static final String SELECTION_LIST = "selectionList";

    @Override
    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        Object owner = parameters.get(OWNER);
        HashSet<EObject> selectionList = new HashSet<EClass>();
        if (parameters.get(SELECTION_LIST) instanceof Collection) {
            selectionList = (Collection)parameters.get(SELECTION_LIST);
        } else {
            selectionList.add((EObject)((EClass)parameters.get(SELECTION_LIST)));
        }
        if (owner instanceof EClass) {
            this.doWork((EClass)owner, selectionList);
        } else if (owner instanceof Collection) {
            Collection list = (Collection)owner;
            for (Object o : list) {
                if (!(o instanceof EClass)) continue;
                this.doWork((EClass)o, selectionList);
            }
        }
    }

    private void doWork(EClass owner, Collection<EObject> selectionList) {
        if (owner != null && selectionList != null && selectionList.size() > 0) {
            for (EObject obj : selectionList) {
                if (obj instanceof EClass && Helper.isExtensible((EClass)obj)) continue;
                String message = "The object '" + ((EClass)obj).getName() + "' is not extensible.";
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Error", (String)message);
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.emde.diagram", message));
                return;
            }
            EAnnotation annotation = ExtensibilityService.getAnnotation(owner, "http://www.polarsys.org/kitalpha/emde/1.0.0/constraint");
            EStringToStringMapEntryImpl constraintEntry = ExtensibilityService.getEntry(annotation, "ExtendedElement");
            EAnnotation annotation2 = ExtensibilityService.getAnnotation(owner, "http://www.polarsys.org/kitalpha/emde/1.0.0/constraintMapping");
            EStringToStringMapEntryImpl mappingEntry = ExtensibilityService.getEntry(annotation2, "Mapping");
            this.setValue(constraintEntry, mappingEntry, selectionList);
        }
    }

    private void setValue(EStringToStringMapEntryImpl constraintEntry, EStringToStringMapEntryImpl mappingEntry, Collection<EObject> selectionList) {
        String value2;
        StringBuilder stringBuilder1 = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String value = constraintEntry.getValue();
        if (value != null) {
            stringBuilder1.append(value);
            stringBuilder1.append(SPACE);
        }
        if ((value2 = mappingEntry.getValue()) != null) {
            stringBuilder2.append(value2);
            stringBuilder2.append(SPACE);
        }
        for (EObject eObject : selectionList) {
            URI oldURI = EcoreUtil.getURI((EObject)eObject);
            String fragment = oldURI.fragment();
            EPackage ePackage = this.getEPackage(eObject);
            String nsURI = ePackage.getNsURI();
            String uri = String.valueOf(nsURI) + "#" + fragment;
            if (value == null || !value.contains(uri)) {
                stringBuilder1.append(uri);
                stringBuilder1.append(SPACE);
            }
            String oldURIString = oldURI.toString();
            if (value2 != null && value2.contains(oldURIString)) continue;
            stringBuilder2.append(oldURIString);
            stringBuilder2.append(SPACE);
        }
        constraintEntry.setValue(stringBuilder1.toString());
        mappingEntry.setValue(stringBuilder2.toString());
    }

    private EPackage getEPackage(EObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EPackage) {
            return (EPackage)object;
        }
        return this.getEPackage(object.eContainer());
    }

    private static class Helper {
        private Helper() {
        }

        public static boolean isExtensible(EClass eclass) {
            EClass extensibleElement = EmdePackage.eINSTANCE.getExtensibleElement();
            for (EClass clazz : eclass.getEAllSuperTypes()) {
                if (!clazz.getName().equals(extensibleElement.getName())) continue;
                return true;
            }
            return false;
        }
    }
}

