/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.kitalpha.emde.extension.ExtendedModel;
import org.polarsys.kitalpha.emde.extension.ExtensionManagerDelegate;
import org.polarsys.kitalpha.emde.extension.ModelExtensionDescriptor;
import org.polarsys.kitalpha.emde.extension.ModelExtensionListener;
import org.polarsys.kitalpha.emde.extension.ModelExtensionManager;
import org.polarsys.kitalpha.emde.extension.ModelExtensionOverallListener;
import org.polarsys.kitalpha.emde.extension.i18n.Messages;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public abstract class DefaultModelExtensionManager
implements ModelExtensionManager {
    private ResourceSet target;
    private List<ExtensionManagerDelegate> delegates = new ArrayList<ExtensionManagerDelegate>();
    private final List<ModelExtensionListener> listeners = new ArrayList<ModelExtensionListener>();
    private static final List<ModelExtensionOverallListener> overallListeners = new ArrayList<ModelExtensionOverallListener>();

    @Override
    public void addListener(ModelExtensionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeListener(ModelExtensionListener l) {
        this.listeners.remove(l);
    }

    static void addOverallListener(ModelExtensionOverallListener l) {
        if (!overallListeners.contains(l)) {
            overallListeners.add(l);
        }
    }

    static void removeOverallListener(ModelExtensionOverallListener l) {
        overallListeners.remove(l);
    }

    protected void fireExtensionEvent(String nsURI, boolean enable) {
        for (ModelExtensionListener modelExtensionListener : this.listeners) {
            try {
                if (enable) {
                    modelExtensionListener.modelEnabled(nsURI);
                    continue;
                }
                modelExtensionListener.modelDisabled(nsURI);
            }
            catch (Exception e) {
                Log.RUNTIME.logError(Messages.Listener_Error, (Throwable)e);
            }
        }
        for (ModelExtensionOverallListener modelExtensionOverallListener : overallListeners) {
            try {
                if (enable) {
                    modelExtensionOverallListener.modelEnabled(null, nsURI);
                    continue;
                }
                modelExtensionOverallListener.modelDisabled(null, nsURI);
            }
            catch (Exception e) {
                Log.RUNTIME.logError(Messages.Listener_Error, (Throwable)e);
            }
        }
    }

    @Override
    public boolean isExtensionModelDisabled(String extensibleModel, String extendedModel) {
        ExtendedModel extendedModel2 = ModelExtensionDescriptor.INSTANCE.getExtendedModel(extendedModel);
        if (extendedModel2 == null) {
            return true;
        }
        return this.isExtensionModelDisabled(extendedModel2);
    }

    @Override
    public boolean canDisableExtensionModel(ExtendedModel extended) {
        return true;
    }

    @Override
    public boolean isExtensionModelDisabled(Object object) {
        return object instanceof EObject && this.isExtensionModelDisabled((EObject)object);
    }

    @Override
    public boolean isExtensionModelDisabled(EObject eObject) {
        if (eObject.eResource() == null) {
            return false;
        }
        String nsURI = eObject.eClass().getEPackage().getNsURI();
        for (ExtensionManagerDelegate delegate : this.delegates) {
            Boolean extensionModelDisabled;
            if (!delegate.getManagedNsUris().contains(nsURI) || (extensionModelDisabled = delegate.isExtensionModelDisabled(eObject)) == null) continue;
            return extensionModelDisabled;
        }
        ExtendedModel extended = ModelExtensionDescriptor.INSTANCE.getExtendedModel(eObject.eClass().getEPackage().getNsURI().toString());
        return extended != null && this.isExtensionModelDisabled(extended);
    }

    @Override
    public List<ExtensionManagerDelegate> getDelegates() {
        return this.delegates;
    }
}

