/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.kitalpha.emde.extension.DefaultModelExtensionManager;
import org.polarsys.kitalpha.emde.extension.ExtensionManagerDelegate;
import org.polarsys.kitalpha.emde.extension.ModelExtensionManager;
import org.polarsys.kitalpha.emde.extension.ModelExtensionOverallListener;
import org.polarsys.kitalpha.emde.extension.preferences.PreferenceModelExtensionManager;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public class ModelExtensionHelper {
    private static final ModelExtensionManager instance = ModelExtensionHelper.createInstance();

    public static ModelExtensionManager getInstance(Resource resource) {
        return ModelExtensionHelper.getInstance();
    }

    public static ModelExtensionManager getInstance(ResourceSet ctx) {
        return ModelExtensionHelper.getInstance();
    }

    public static ModelExtensionManager getInstance(EObject ctx) {
        return ModelExtensionHelper.getInstance();
    }

    private static ModelExtensionManager getInstance() {
        return instance;
    }

    private static ModelExtensionManager createInstance() {
        try {
            IConfigurationElement[] elts = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.emde.extension.model.manager");
            if (elts.length == 0) {
                return new PreferenceModelExtensionManager();
            }
            if (elts.length == 1) {
                return ModelExtensionHelper.configure((ModelExtensionManager)elts[0].createExecutableExtension("class"));
            }
            if (elts.length > 1) {
                Log.getDefault().logWarning("Got " + elts.length + " implementations for PE 'org.polarsys.kitalpha.emde.extension.model.manager'");
            }
            return ModelExtensionHelper.configure((ModelExtensionManager)elts[0].createExecutableExtension("class"));
        }
        catch (CoreException e) {
            Log.getDefault().logError((Throwable)e);
            return new PreferenceModelExtensionManager();
        }
    }

    private static ModelExtensionManager configure(ModelExtensionManager mgr) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.emde.extension.model.manager.delegate");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            ExtensionManagerDelegate delegate = (ExtensionManagerDelegate)elt.createExecutableExtension("class");
            mgr.getDelegates().add(delegate);
            ++n2;
        }
        return mgr;
    }

    public static void addOverallListener(ModelExtensionOverallListener l) {
        DefaultModelExtensionManager.addOverallListener(l);
    }

    public static void removeOverallListener(ModelExtensionOverallListener l) {
        DefaultModelExtensionManager.removeOverallListener(l);
    }
}

