/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.api.permission.exception;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.sirius.ecore.extender.business.internal.Messages;

public class LockedInstanceException
extends RuntimeException {
    public static final String PERMISSION_ISSUE_MESSAGE = Messages.LockedInstanceException_message;
    private static final long serialVersionUID = 1L;
    private final EObject[] lockedElements;

    public LockedInstanceException(EObject ... lockedElements) {
        super(String.valueOf(PERMISSION_ISSUE_MESSAGE) + LockedInstanceException.getText(lockedElements));
        this.lockedElements = lockedElements;
    }

    public LockedInstanceException(String message) {
        super(message);
        this.lockedElements = null;
    }

    private static String getText(EObject[] eObjects) {
        String text = "";
        if (eObjects != null) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
            int i = 0;
            while (i < eObjects.length) {
                EObject eObject = eObjects[i];
                if (eObject != null) {
                    text = String.valueOf(text) + adapterFactoryItemDelegator.getText((Object)eObject) + " (" + eObject + ")";
                    if (i != eObjects.length - 1) {
                        text = String.valueOf(text) + ", ";
                    }
                }
                ++i;
            }
            adapterFactory.dispose();
        }
        return text;
    }

    public EObject getLockedElement() {
        return this.lockedElements != null && this.lockedElements.length > 0 ? this.lockedElements[0] : null;
    }

    public EObject[] getLockedElements() {
        return this.lockedElements;
    }
}

