/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.tool.internal.action.repair;

import com.google.common.collect.Iterables;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.business.api.repair.IRepairParticipant;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.migration.resource.session.commands.MigrationCommandExecutor;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.flag.SequenceDiagramAbsoluteBoundsFlagger;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationContainer;
import org.eclipse.sirius.viewpoint.DView;

public class SequenceDiagramRepairParticipant
implements IRepairParticipant {
    public void repairStarted() {
    }

    public void repairCompeleted() {
    }

    public void restoreModelElementState(DView view, IProgressMonitor monitor) {
        Resource resource = view.eResource();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)resource);
        new MigrationCommandExecutor().execute(editingDomain, this.migrateModel(resource, editingDomain));
    }

    public void postRefreshOperations(TransactionalEditingDomain domain, Resource resource) {
    }

    public void saveModelElementState(DView view, IProgressMonitor monitor) {
    }

    private Command migrateModel(Resource model, TransactionalEditingDomain domain) {
        CompoundCommand cc = new CompoundCommand(Messages.SequenceDiagramRepairParticipant_repairCommandName);
        EObject eObject = (EObject)model.getContents().get(0);
        if (eObject instanceof DAnalysis) {
            DAnalysis dAnalysis = (DAnalysis)eObject;
            for (DRepresentationContainer container : Iterables.filter((Iterable)dAnalysis.getOwnedViews(), DRepresentationContainer.class)) {
                CompoundCommand migrateRepresentationContainer = this.migrateRepresentationContainer(container, domain);
                if (migrateRepresentationContainer.getCommandList().isEmpty()) continue;
                cc.append((Command)migrateRepresentationContainer);
            }
        }
        return cc;
    }

    private CompoundCommand migrateRepresentationContainer(DRepresentationContainer container, TransactionalEditingDomain domain) {
        CompoundCommand cc = new CompoundCommand(Messages.SequenceDiagramRepairParticipant_repairCommandName);
        for (SequenceDDiagram seqDDiag : Iterables.filter((Iterable)container.getOwnedRepresentations(), SequenceDDiagram.class)) {
            Diagram gmfDiagram = SiriusGMFHelper.getGmfDiagram((DDiagram)seqDDiag);
            Option<SequenceDiagram> iSequenceDiagram = ISequenceElementAccessor.getSequenceDiagram(gmfDiagram);
            if (!iSequenceDiagram.some()) continue;
            cc.append((Command)new SequenceInstanceRoleRepairCommand((SequenceDiagram)iSequenceDiagram.get(), domain));
            cc.append((Command)new FlagSequenceEventsCommand(domain, (SequenceDiagram)iSequenceDiagram.get()));
        }
        return cc;
    }

    public void endRepairOnView() {
    }

    public void startRepairOnView(Session session, DView view) {
    }

    public void removeElements(DView view, TransactionalEditingDomain domain, IProgressMonitor monitor) {
    }

    public List<DRepresentation> cleanRepresentations(EList<DRepresentation> representations) {
        return new LinkedList<DRepresentation>();
    }

    public void refreshRepresentations(DAnalysis dAnalysis, DView view) {
    }

    private class FlagSequenceEventsCommand
    extends RecordingCommand {
        SequenceDiagram diagram;

        public FlagSequenceEventsCommand(TransactionalEditingDomain domain, SequenceDiagram diagram) {
            super(domain, Messages.FlagSequenceEventsCommand_commandName);
            this.diagram = diagram;
        }

        protected void doExecute() {
            if (this.diagram != null) {
                new SequenceDiagramAbsoluteBoundsFlagger(this.diagram).flag();
            }
        }
    }

    private class SequenceInstanceRoleRepairCommand
    extends RecordingCommand {
        private SequenceDiagram sequenceDiagram;

        public SequenceInstanceRoleRepairCommand(SequenceDiagram sequenceDiagram, TransactionalEditingDomain editingDomain) {
            super(editingDomain);
            this.sequenceDiagram = sequenceDiagram;
        }

        protected void doExecute() {
            this.fixInstanceRoleBounds();
        }

        private void fixInstanceRoleBounds() {
            for (InstanceRole ir : this.sequenceDiagram.getAllInstanceRoles()) {
                Node notationNode = ir.getNotationNode();
                if (notationNode == null || !(notationNode.getLayoutConstraint() instanceof Size) || !(notationNode.getElement() instanceof DNode)) continue;
                Size size = (Size)notationNode.getLayoutConstraint();
                DNode dNode = (DNode)notationNode.getElement();
                Dimension dim = new DNodeQuery(dNode).getDefaultDimension();
                if (size.getWidth() == -1 && dim != null) {
                    size.setWidth(dim.width);
                }
                if (size.getHeight() != -1 || dim == null) continue;
                size.setHeight(dim.height);
            }
        }
    }
}

