/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapterImpl;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.emf.EReferencePredicate;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.tools.api.ui.RefreshEditorsPrecommitListener;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class DanglingRefRemovalTrigger
implements ModelChangeTrigger {
    public static final int DANGLING_REFERENCE_REMOVAL_PRIORITY = 0;
    public static final Predicate<Notification> IS_DETACHMENT = new Predicate<Notification>(){

        public boolean apply(Notification input) {
            boolean potentialImplicitDetachment;
            boolean potentialExplicitDetachment = input.getEventType() == 4 || input.getEventType() == 6 || input.getEventType() == 2;
            boolean bl = potentialImplicitDetachment = input.getEventType() == 1 && input.getNewValue() == null;
            if (potentialExplicitDetachment || potentialImplicitDetachment) {
                return input.getFeature() instanceof EReference && ((EReference)input.getFeature()).isContainment();
            }
            return false;
        }
    };
    public static final Predicate<Notification> IS_ATTACHMENT = new Predicate<Notification>(){

        public boolean apply(Notification input) {
            if (input.getEventType() == 3 || input.getEventType() == 5 || input.getEventType() == 1) {
                return input.getFeature() instanceof EReference && ((EReference)input.getFeature()).isContainment() && input.getNewValue() != null;
            }
            return false;
        }
    };
    public static final EReferencePredicate DSEMANTICDECORATOR_REFERENCE_TO_IGNORE_PREDICATE = new EReferencePredicate(){

        public boolean apply(EReference reference) {
            return ViewpointPackage.Literals.DSEMANTIC_DECORATOR.isSuperTypeOf(reference.getEContainingClass());
        }
    };
    public static final EReferencePredicate NOTATION_VIEW_ELEMENT_REFERENCE_TO_IGNORE_PREDICATE = new EReferencePredicate(){

        public boolean apply(EReference eReference) {
            return DanglingRefRemovalTrigger.NOTATION_VIEW_ELEMENT_REFERENCE_TO_IGNORE.equals(eReference.getName()) && DanglingRefRemovalTrigger.NOTATION_VIEW_ELEMENT_REFERENCE_CONTAINER_TO_IGNORE.equals(eReference.getContainerClass().getName());
        }
    };
    public static final Predicate<EReference> EPACKAGE_EFACTORYINSTANCE_REFERENCE_TO_IGNORE_PREDICATE = new Predicate<EReference>(){

        public boolean apply(EReference eReference) {
            return EcorePackage.eINSTANCE.getEPackage_EFactoryInstance().equals(eReference);
        }
    };
    private static final String NOTATION_VIEW_ELEMENT_REFERENCE_TO_IGNORE = "element";
    private static final String NOTATION_VIEW_ELEMENT_REFERENCE_CONTAINER_TO_IGNORE = "org.eclipse.gmf.runtime.notation.View";
    private Session session;

    public DanglingRefRemovalTrigger(Session session) {
        this.session = session;
    }

    @Override
    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        Set<EObject> allDetachedObjects = this.getChangedEObjectsAndChildren(Iterables.filter(notifications, IS_DETACHMENT), null);
        if (allDetachedObjects.size() > 0) {
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.CLEANING_REMOVEDANGLING_KEY);
            Predicate ignoreNotifierInDetachedObjects = Predicates.in(allDetachedObjects);
            Set<EObject> allAttachedObjects = this.getChangedEObjectsAndChildren(Iterables.filter(notifications, IS_ATTACHMENT), (Predicate<EObject>)ignoreNotifierInDetachedObjects);
            Sets.SetView toRemoveXRefFrom = Sets.difference(allDetachedObjects, allAttachedObjects);
            if (toRemoveXRefFrom.size() > 0) {
                EReferencePredicate refToIgnore = new EReferencePredicate(){

                    public boolean apply(EReference ref) {
                        return DSEMANTICDECORATOR_REFERENCE_TO_IGNORE_PREDICATE.apply(ref) || NOTATION_VIEW_ELEMENT_REFERENCE_TO_IGNORE_PREDICATE.apply(ref) || EPACKAGE_EFACTORYINSTANCE_REFERENCE_TO_IGNORE_PREDICATE.apply((Object)ref);
                    }
                };
                RemoveDanglingReferencesCommand removeDangling = new RemoveDanglingReferencesCommand(this.session.getTransactionalEditingDomain(), this.session.getModelAccessor(), this.session.getSemanticCrossReferencer(), this.session.getSemanticResources(), this.session.getRefreshEditorsListener(), (Collection<EObject>)toRemoveXRefFrom, refToIgnore);
                DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.CLEANING_REMOVEDANGLING_KEY);
                return Options.newSome((Object)((Object)removeDangling));
            }
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.CLEANING_REMOVEDANGLING_KEY);
        }
        return Options.newNone();
    }

    protected Set<EObject> getChangedEObjectsAndChildren(Iterable<Notification> notifications, Predicate<EObject> notifierToIgnore) {
        LinkedHashSet changedEObjects = Sets.newLinkedHashSet();
        for (Notification notification : notifications) {
            if (notifierToIgnore != null && (!(notification.getNotifier() instanceof EObject) || notifierToIgnore.apply((Object)((EObject)notification.getNotifier())))) continue;
            for (EObject root : this.getNotificationValues(notification)) {
                if (changedEObjects.contains(root)) continue;
                changedEObjects.add(root);
                Iterators.addAll((Collection)changedEObjects, (Iterator)root.eAllContents());
            }
        }
        return changedEObjects;
    }

    protected Set<EObject> getNotificationValues(Notification notification) {
        LinkedHashSet values = Sets.newLinkedHashSet();
        Object value = notification.getOldValue();
        if (IS_ATTACHMENT.apply((Object)notification)) {
            value = notification.getNewValue();
        }
        if (value instanceof Collection) {
            Iterables.addAll((Collection)values, (Iterable)Iterables.filter((Iterable)((Collection)value), EObject.class));
        } else if (value instanceof EObject) {
            values.add((EObject)value);
        }
        return values;
    }

    @Override
    public int priority() {
        return 0;
    }

    private static class RemoveDanglingReferencesCommand
    extends RecordingCommand {
        private final Collection<EObject> toRemoveXRefFrom = Sets.newLinkedHashSet();
        private final EReferencePredicate isReferenceToIgnorePredicate;
        private ModelAccessor modelAccessor;
        private ECrossReferenceAdapter xReferencer;
        private Collection<Resource> semanticResources;
        private RefreshEditorsPrecommitListener refreshEditorsPrecommitListener;

        public RemoveDanglingReferencesCommand(TransactionalEditingDomain domain, ModelAccessor accessor, ECrossReferenceAdapter xRef, Collection<Resource> semanticResources, RefreshEditorsPrecommitListener refreshEditorsPrecommitListener, Collection<EObject> toRemoveXRefFrom, EReferencePredicate isReferenceToIgnore) {
            super(domain, Messages.DanglingRefRemovalTrigger_removeDanglingCmdLabel);
            this.modelAccessor = accessor;
            this.xReferencer = xRef;
            this.semanticResources = semanticResources;
            this.refreshEditorsPrecommitListener = refreshEditorsPrecommitListener;
            this.toRemoveXRefFrom.addAll(toRemoveXRefFrom);
            this.isReferenceToIgnorePredicate = isReferenceToIgnore;
        }

        protected void doExecute() {
            ArrayList impactedEObjects = new ArrayList();
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.CLEANING_REMOVEDANGLING_KEY);
            for (EObject eObject : this.toRemoveXRefFrom) {
                SiriusCrossReferenceAdapterImpl filteredCrossReferencer = new SiriusCrossReferenceAdapterImpl(){

                    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject eObject, boolean resolve) {
                        Collection settings = RemoveDanglingReferencesCommand.this.xReferencer.getInverseReferences(eObject, resolve);
                        ArrayList settingsToTryToUnset = Lists.newArrayList();
                        for (EStructuralFeature.Setting s : settings) {
                            if (RemoveDanglingReferencesCommand.this.toRemoveXRefFrom.contains(s.getEObject())) continue;
                            settingsToTryToUnset.add(s);
                        }
                        return settingsToTryToUnset;
                    }
                };
                impactedEObjects.addAll(this.modelAccessor.eRemoveInverseCrossReferences(eObject, (ECrossReferenceAdapter)filteredCrossReferencer, this.isReferenceToIgnorePredicate));
            }
            for (EObject impactedEObject : impactedEObjects) {
                Resource resource = impactedEObject.eResource();
                if (!this.semanticResources.contains(resource)) continue;
                this.refreshEditorsPrecommitListener.disable();
                break;
            }
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.CLEANING_REMOVEDANGLING_KEY);
            this.toRemoveXRefFrom.clear();
            this.modelAccessor = null;
            this.xReferencer = null;
            this.semanticResources = null;
            this.refreshEditorsPrecommitListener = null;
        }
    }
}

