/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.util.LazyCrossReferencer;

public class SessionLazyCrossReferencer
extends LazyCrossReferencer {
    private DAnalysisSessionImpl session;

    public SessionLazyCrossReferencer(DAnalysisSessionImpl session) {
        this.session = session;
    }

    protected void initialize() {
        super.initialize();
        Collection<Resource> semanticResources = this.session.getSemanticResources();
        EList<Resource> controlledResources = this.session.getControlledResources();
        Set<Resource> allSessionResources = this.session.getAllSessionResources();
        Iterable resources = Iterables.concat(semanticResources, controlledResources, allSessionResources);
        for (Resource resource : resources) {
            EList adapters = resource.eAdapters();
            if (adapters.contains((Object)this)) continue;
            adapters.add(this);
        }
    }
}

