/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.af.integration;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.viewpoint.description.Group;
import org.polarsys.kitalpha.ad.integration.sirius.model.SiriusFactory;
import org.polarsys.kitalpha.ad.integration.sirius.model.SiriusRepresentation;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Metamodel;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Representation;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.RepresentationElement;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ViewpointFactory;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.af.integration.bundles.AFBundlesIntegration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.af.integration.exception.AFIntegrationException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.af.integration.model.AFEcoreIntegration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.af.integration.model.AFRepresentationIntegration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.PDEUtility;

public class AFIntegrationManager {
    private static AFIntegrationManager INSTANCE = new AFIntegrationManager();
    private Viewpoint viewpoint = null;

    public static AFIntegrationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AFIntegrationManager();
        }
        return INSTANCE;
    }

    public Viewpoint getViewpoint() {
        return this.viewpoint;
    }

    public void setViewpoint(Viewpoint viewpoint) {
        this.viewpoint = viewpoint;
    }

    public void patchManifest(String model_uri) throws AFIntegrationException {
        URI uri = URI.createURI((String)model_uri);
        if (uri == null || uri.segments().length <= 2) {
            throw new AFIntegrationException(40);
        }
        String bundle_ID = uri.segment(1);
        this.doPatchManifest(bundle_ID);
    }

    public void patchManifest(Viewpoint viewpoint) throws AFIntegrationException {
        EObject root = EcoreUtil.getRootContainer((EObject)viewpoint, (boolean)true);
        if (root == null) {
            throw new AFIntegrationException(40);
        }
        String bundle_ID = root.eResource().getURI().segment(1);
        this.doPatchManifest(bundle_ID);
    }

    private void doPatchManifest(String bundle_ID) throws AFIntegrationException {
        IProject af_project = null;
        if (bundle_ID != null && bundle_ID.trim().length() > 0) {
            List<String> list;
            af_project = ResourcesPlugin.getWorkspace().getRoot().getProject(bundle_ID);
            if (af_project.exists() && (list = AFBundlesIntegration.getInstance().getRequiredBundles()) != null && !list.isEmpty()) {
                PDEUtility.updateRequiredBundles((IProject)af_project, list, null);
            }
        } else {
            throw new AFIntegrationException(100);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void patchModel(String model_uri) throws AFIntegrationException {
        URI uri = URI.createURI((String)model_uri);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = null;
        try {
            r = rs.getResource(uri, true);
        }
        catch (Exception e) {
            return;
        }
        Viewpoint vp = null;
        if (r.getContents() != null && r.getContents().size() > 0) {
            EObject root = (EObject)r.getContents().get(0);
            if (!(root instanceof Viewpoint)) throw new AFIntegrationException(30);
            vp = (Viewpoint)root;
        } else if (this.viewpoint != null) {
            vp = this.viewpoint;
        }
        if (vp == null) return;
        this.doPatchModel(vp);
    }

    private void doPatchModel(Viewpoint viewpoint) throws AFIntegrationException {
        this.patchMetaModels(viewpoint);
        this.patchRepresentations(viewpoint);
        this.saveAFModel(viewpoint);
    }

    private void patchMetaModels(Viewpoint viewpoint) {
        Metamodel metaModel = viewpoint.getMetamodel();
        if (metaModel == null) {
            metaModel = ViewpointFactory.eINSTANCE.createMetamodel();
            viewpoint.setMetamodel(metaModel);
        }
        List<EPackage> epackage_list = AFEcoreIntegration.getInstance().getEPackageToRegister();
        for (EPackage ePackage : epackage_list) {
            if (this.isEPackageRegistered(metaModel, ePackage)) continue;
            metaModel.getModels().add((Object)ePackage);
        }
    }

    private boolean isEPackageRegistered(Metamodel metaModel, EPackage ePackage) {
        for (EPackage iEPackage : metaModel.getModels()) {
            if (!iEPackage.getName().equals(ePackage.getName()) || !iEPackage.getNsURI().equals(ePackage.getNsURI())) continue;
            return true;
        }
        return false;
    }

    private void patchRepresentations(Viewpoint viewpoint) {
        Representation representation = viewpoint.getRepresentation();
        if (representation == null) {
            representation = ViewpointFactory.eINSTANCE.createRepresentation();
            viewpoint.setRepresentation(representation);
        }
        List<Group> representation_list = AFRepresentationIntegration.getInstance().getRepresentationToRegister();
        for (Group group : representation_list) {
            if (this.isRepresentationRegistered(representation, group)) continue;
            SiriusRepresentation siriusRepresentation = SiriusFactory.eINSTANCE.createSiriusRepresentation();
            siriusRepresentation.setOdesign(group);
            representation.getRepresentations().add((Object)siriusRepresentation);
        }
    }

    private boolean isRepresentationRegistered(Representation representation, Group group) {
        for (RepresentationElement iRepresentationElement : representation.getRepresentations()) {
            Group iGroup;
            if (!(iRepresentationElement instanceof SiriusRepresentation) || !(iGroup = ((SiriusRepresentation)iRepresentationElement).getOdesign()).getName().equals(group.getName()) || !iGroup.eResource().getURI().toPlatformString(true).equals(group.eResource().getURI().toPlatformString(true))) continue;
            return true;
        }
        return false;
    }

    private void saveAFModel(Viewpoint viewpoint) throws AFIntegrationException {
        try {
            boolean vpWasActif = ViewpointManager.getInstance(null).isActive(viewpoint.getId());
            if (vpWasActif) {
                ViewpointManager.getInstance(null).desactivate(viewpoint.getId());
            }
            Resource resource = viewpoint.eResource();
            resource.save(Collections.EMPTY_MAP);
            if (vpWasActif) {
                ViewpointManager.getInstance(null).activate(viewpoint.getId());
            }
        }
        catch (IOException e) {
            throw new AFIntegrationException(30, "An exception occures when trying to save AF model ", e.getStackTrace());
        }
        catch (ViewpointActivationException e1) {
            throw new AFIntegrationException(30, "An exception occures when trying to save AF model ", e1.getStackTrace());
        }
    }

    public void clearComponentsList() {
        this.viewpoint = null;
        AFEcoreIntegration.getInstance().getEPackageToRegister().clear();
        AFRepresentationIntegration.getInstance().getRepresentationToRegister().clear();
        AFBundlesIntegration.getInstance().getRequiredBundles().clear();
    }
}

