/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.contrib.unknownreferences.command;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.DRepresentationContainer;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.contrib.unknownreferences.Messages;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.Scrutineer;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidDMapping;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidDRepresentationContainer;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidFilterDescription;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidLayer;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.MissingEPackage;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;

public class UnknownreferencesCleaner
extends ModelCommand {
    Logger LOGGER = Logger.getLogger(UnknownreferencesCleaner.class);

    private ECrossReferenceAdapter installCrossReferencer(Resource resource) {
        ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter();
        EList resources = resource.getResourceSet().getResources();
        for (Resource resource2 : resources) {
            resource2.eAdapters().add((Object)crossReferenceAdapter);
        }
        return crossReferenceAdapter;
    }

    public void exec(Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        ECrossReferenceAdapter crossReferenceAdapter = this.installCrossReferencer(resource);
        try {
            ModelScrutinyRegistry.RegistryElement regElt = Scrutineer.getRegistryElement((String)this.getModelAnalysisID());
            monitor.beginTask(Messages.CLEAN_UNKNOWNREFERENCE_TASK, 1);
            for (IScrutinize finder : regElt.getFinders()) {
                DDiagram dDiagram;
                if (finder instanceof InvalidDMapping) {
                    monitor.subTask(Messages.CLEAN_INVALID_MAPPINGS);
                    InvalidDMapping invalidDMappings = (InvalidDMapping)finder;
                    for (DRepresentationElement dRepresentationElement : invalidDMappings.getAnalysisResult()) {
                        EcoreUtil.remove((EObject)dRepresentationElement);
                    }
                }
                if (finder instanceof InvalidDRepresentationContainer) {
                    monitor.subTask(Messages.CLEAN_INVALID_REPRESENTATION_CONTAINER);
                    InvalidDRepresentationContainer invalidDRepresentationContainer = (InvalidDRepresentationContainer)finder;
                    for (DRepresentationContainer dRepresentationContainer : invalidDRepresentationContainer.getAnalysisResult()) {
                        EcoreUtil.remove((EObject)dRepresentationContainer);
                    }
                }
                if (finder instanceof InvalidFilterDescription) {
                    monitor.subTask(Messages.CLEAN_INVALID_FILTER_DESCRIPTION);
                    InvalidFilterDescription invalidFilterDescription = (InvalidFilterDescription)finder;
                    for (FilterDescription filterDescription : invalidFilterDescription.getAnalysisResult()) {
                        for (EStructuralFeature.Setting setting : crossReferenceAdapter.getInverseReferences((EObject)filterDescription)) {
                            if (!setting.getEStructuralFeature().equals(DiagramPackage.eINSTANCE.getDDiagram_ActivatedFilters())) continue;
                            dDiagram = (DDiagram)setting.getEObject();
                            dDiagram.getActivatedFilters().remove((Object)filterDescription);
                        }
                    }
                }
                if (finder instanceof InvalidLayer) {
                    monitor.subTask(Messages.CLEAN_INVALID_LAYER);
                    InvalidLayer invalidLayer = (InvalidLayer)finder;
                    for (Layer layer : invalidLayer.getAnalysisResult()) {
                        for (EStructuralFeature.Setting setting : crossReferenceAdapter.getInverseReferences((EObject)layer)) {
                            if (!setting.getEStructuralFeature().equals(DiagramPackage.eINSTANCE.getDDiagram_ActivatedLayers())) continue;
                            dDiagram = (DDiagram)setting.getEObject();
                            dDiagram.getActivatedLayers().remove((Object)layer);
                        }
                    }
                }
                if (!(finder instanceof MissingEPackage)) continue;
                monitor.subTask(Messages.CLEAN_MISSING_EPACKAGE);
                MissingEPackage missingEPackage = (MissingEPackage)finder;
                for (AnyType anyType : missingEPackage.getAnalysisResult().getAnyTypes()) {
                    EcoreUtil.delete((EObject)anyType, (boolean)true);
                }
                for (XMLResource xmlResource : missingEPackage.getAnalysisResult().getXmlResources()) {
                    xmlResource.getEObjectToExtensionMap().clear();
                }
            }
        }
        catch (ModelScrutinyException e) {
            e.printStackTrace();
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        monitor.worked(1);
        monitor.done();
    }
}

